/*
    Crystal Space static COM linking support
    Copyright (C) 1998 by Jorrit Tyberghein
    Written by Andrew Zabolotny

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "sysdef.h"

#if defined (CS_STATIC_LINKED)

/**
 * Since static COM objects aren't referenced from anywhere in the
 * main engine code, we should make at least one reference from this
 * file: this will force linker to link in all static COM libraries;
 * otherwise they will be quietly ignored.
 * <p>
 * The macros below expects two external functions to be defined
 * inside the COM class library called
 * <pre>
 *   void Name##Register ()
 * </pre>
 * and
 * <pre>
 *   void Name##Unregister ()
 * </pre>
 * their function should be obvious from their names.
 */

#define REGISTER_COM_CLASS(Name)	\
  class __##Name##Initializer		\
  {					\
  public:				\
    __##Name##Initializer ()		\
    {					\
      extern void Name##Register ();	\
      Name##Register ();		\
    }					\
    ~__##Name##Initializer ()		\
    {					\
      extern void Name##Unregister ();	\
      Name##Unregister ();		\
    }					\
  } __##Name##Reference;

// add here all drivers you want be present in static executables
// --- Network
#ifdef SCL_NETSOCKS
  REGISTER_COM_CLASS (NetSocks)
#endif
#ifdef SCL_NETNULL
  REGISTER_COM_CLASS (NetNull)
#endif
#ifdef SCL_NETMANNULL
  REGISTER_COM_CLASS (NetManagerNull)
#endif
#ifdef SCL_NETMANSIMPLE
  REGISTER_COM_CLASS (NetManagerSimple)
#endif

// --- 2D
#ifdef SCL_BE2D
  REGISTER_COM_CLASS (Be2D)
#endif
#ifdef SCL_RAW2D
  REGISTER_COM_CLASS (Raw2D)
#endif
#ifdef SCL_DIVE2D
  REGISTER_COM_CLASS (Dive2D)
#endif
#ifdef SCL_X2D
  REGISTER_COM_CLASS (Xlib2D)
#endif
#ifdef SCL_SVGALIB2D
  REGISTER_COM_CLASS (SVGALib2D)
#endif
#ifdef SCL_GGI2D
  REGISTER_COM_CLASS (GGI2D)
#endif
#ifdef SCL_NEXT2D
  REGISTER_COM_CLASS (NeXT2D)
#endif
#ifdef SCL_GLX2D
  REGISTER_COM_CLASS (Glx2D)
#endif
#ifdef SCL_GLIDEX2D
  REGISTER_COM_CLASS (Glidex2D)
#endif
#ifdef SCL_DDRAW2D
  REGISTER_COM_CLASS (DDraw2D)
#endif
#ifdef SCL_GL2DOS2
  REGISTER_COM_CLASS (OS2GL2D)
#endif
#ifdef SCL_ASCII2D
  REGISTER_COM_CLASS (AA)
#endif

// --- 3D
#ifdef SCL_SOFT3D
  REGISTER_COM_CLASS (SoftRender)
#endif
#ifdef SCL_OPENGL3D
  REGISTER_COM_CLASS (OpenGLRender)
#endif
#ifdef SCL_GLIDE3D
  REGISTER_COM_CLASS (GlideRender)
#endif

// --- Sound
#ifdef SCL_SNDDRVN
  REGISTER_COM_CLASS (SoundDriverNull)
#endif
#ifdef SCL_SNDOSS
  REGISTER_COM_CLASS (SoundDriverOSS)
#endif
#ifdef SCL_SNDRDRN
  REGISTER_COM_CLASS (SoundRenderNull)
#endif
#ifdef SCL_SNDRDRS
  REGISTER_COM_CLASS (SoundRenderSoftware)
#endif

// This function is called from outside so that this module gets linked in
extern "C" void csInitializeStaticCOM ()
{
}

#endif // CS_STATIC_LINKED
