# Application description
DESCRIPTION.sqk = Squawk test application

#-------------------------------------------------------------- rootdefines ---#
ifeq ($(MAKESECTION),rootdefines)

# Application-specific help commands
APPHELP += $(NEWLINE)echo $"  make sqk          Make the $(DESCRIPTION.sqk)$"

endif # ifeq ($(MAKESECTION),rootdefines)

#-------------------------------------------------------------- roottargets ---#
ifeq ($(MAKESECTION),roottargets)

.PHONY: sqk

all apps: sqk
sqk:
	$(MAKE_TARGET)

endif # ifeq ($(MAKESECTION),roottargets)

#-------------------------------------------------------------- postdefines ---#
ifeq ($(MAKESECTION),postdefines)

vpath %.cpp apps/squawk apps/support

SQUAWK.EXE=squawk$(EXE)
SRC.SQUAWK = $(wildcard apps/squawk/*.cpp) \
  apps/support/static.cpp apps/support/cspace.cpp
OBJ.SQUAWK = $(addprefix $(OUT),$(notdir $(SRC.SQUAWK:.cpp=$O)))
DESCRIPTION.$(SQUAWK.EXE) = $(DESCRIPTION.sqk)

endif # ifeq ($(MAKESECTION),postdefines)

#------------------------------------------------------------------ targets ---#
ifeq ($(MAKESECTION),targets)

.PHONY: sqk sqkclean

all: $(SQUAWK.EXE)
sqk: $(OUTDIRS) $(SQUAWK.EXE)
clean: sqkclean

$(SQUAWK.EXE): $(DEP.EXE) $(OBJ.SQUAWK) \
  $(CSTOOLS.LIB) $(CSPARSER.LIB) $(CSENGINE.LIB) $(CSSCRIPT.LIB) \
  $(CSSNDLDR.LIB) $(CSGFXLDR.LIB) $(CSUTIL.LIB) \
  $(CSCOM.LIB) $(CSSYS.LIB) $(CSGEOM.LIB) $(CSINPUT.LIB) $(CSOBJECT.LIB)
	$(DO.LINK.EXE)

sqkclean:
	-$(RM) $(SQUAWK.EXE)

ifdef DO_DEPEND
depend: $(OUTOS)squawk.dep
$(OUTOS)squawk.dep: $(SRC.SQUAWK)
	$(DO.DEP)
else
-include $(OUTOS)squawk.dep
endif

endif # ifeq ($(MAKESECTION),targets)
