# Application description
DESCRIPTION.simp = Crystal Space simple example

#-------------------------------------------------------------- rootdefines ---#
ifeq ($(MAKESECTION),rootdefines)

# Application-specific help commands
APPHELP += $(NEWLINE)echo $"  make simp         Make the $(DESCRIPTION.simp)$"

endif # ifeq ($(MAKESECTION),rootdefines)

#-------------------------------------------------------------- roottargets ---#
ifeq ($(MAKESECTION),roottargets)

.PHONY: simp

all apps: simp
simp:
	$(MAKE_TARGET)

endif # ifeq ($(MAKESECTION),roottargets)

#-------------------------------------------------------------- postdefines ---#
ifeq ($(MAKESECTION),postdefines)

vpath %.cpp apps/simple apps/support

SIMPLE.EXE=simple$(EXE)
SRC.SIMPLE = $(wildcard apps/simple/*.cpp) \
  apps/support/static.cpp apps/support/cspace.cpp
OBJ.SIMPLE = $(addprefix $(OUT),$(notdir $(SRC.SIMPLE:.cpp=$O)))
DESCRIPTION.$(SIMPLE.EXE) = $(DESCRIPTION.simp)

endif # ifeq ($(MAKESECTION),postdefines)

#------------------------------------------------------------------ targets ---#
ifeq ($(MAKESECTION),targets)

.PHONY: simp simpclean

all: $(SIMPLE.EXE)
simp: $(OUTDIRS) $(SIMPLE.EXE)
clean: simpclean

$(SIMPLE.EXE): $(DEP.EXE) $(OBJ.SIMPLE) \
  $(CSPARSER.LIB) $(CSENGINE.LIB) $(CSSCRIPT.LIB) \
  $(CSSNDLDR.LIB) $(CSGFXLDR.LIB) $(CSUTIL.LIB) \
  $(CSCOM.LIB) $(CSSYS.LIB) $(CSGEOM.LIB) $(CSINPUT.LIB) $(CSOBJECT.LIB)
	$(DO.LINK.EXE)

simpclean:
	-$(RM) $(SIMPLE.EXE)

ifdef DO_DEPEND
depend: $(OUTOS)simple.dep
$(OUTOS)simple.dep: $(SRC.SIMPLE)
	$(DO.DEP)
else
-include $(OUTOS)simple.dep
endif

endif # ifeq ($(MAKESECTION),targets)
