/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef GSENTRY_H
#define GSENTRY_H

class geSentry : public geMonster
{
  typedef geMonster inherited;
public:
  geSentry(geContainer* pContainer);
  virtual ~geSentry();
  IMPLEMENT_GETYPEINFO(geSentry);

  void Create(gePosition Pos);

  // Overridden from gePhysicalObject:
  virtual void OnFinishedAnimation(geSprite3D* pSprite);

  virtual void Hit(int Damage, gePhysicalObject* pHitObject);
  virtual void Die(gePhysicalObject* pLastHitObject);

  typedef enum {PH_Walk, PH_Run,    PH_Look, PH_Shoot, 
                PH_Die,  PH_Repeat, PH_End} Phase;

  csVector3 GetRandomMoveDirection();

  /// Overridden from geObject
  virtual bool Move(csVector3 Offset);
  virtual void HandleWorldCollision();
protected:
  enum   {OM_Patrol, OM_Attack, OM_Flee, OM_Dead} m_OperationsMode;
  int    m_PhaseCounter;
  Phase* m_Phases;
  int    m_Phaseloop;
  float  m_Direction;
};

#endif //GSENTRY_H
