# Application description
DESCRIPTION.ndrvdem = Crystal Space Network Driver Demo

#-------------------------------------------------------------- rootdefines ---#
ifeq ($(MAKESECTION),rootdefines)

# Application-specific help commands
APPHELP += $(NEWLINE)echo $"  make ndrvdem      Make the $(DESCRIPTION.ndrvdem)$"

endif # ifeq ($(MAKESECTION),rootdefines)

#-------------------------------------------------------------- roottargets ---#
ifeq ($(MAKESECTION),roottargets)

.PHONY: ndrvdem

all apps: ndrvdem
ndrvdem:
	$(MAKE_TARGET)

endif # ifeq ($(MAKESECTION),roottargets)

#-------------------------------------------------------------- postdefines ---#
ifeq ($(MAKESECTION),postdefines)

vpath %.cpp apps/ndrvdemo apps/support

CLIENT.EXE=client$(EXE)
SRC.CLIENT = apps/ndrvdemo/client.cpp apps/ndrvdemo/core.cpp \
  apps/support/static.cpp apps/support/cspace.cpp apps/support/command.cpp
OBJ.CLIENT = $(addprefix $(OUT),$(notdir $(SRC.CLIENT:.cpp=$O)))
DESCRIPTION.$(CLIENT.EXE) = $(DESCRIPTION.ndrvdem) (Client)

SERVER.EXE=server$(EXE)
SRC.SERVER = apps/ndrvdemo/server.cpp apps/ndrvdemo/core.cpp \
  apps/support/static.cpp apps/support/cspace.cpp \
  apps/support/command.cpp
OBJ.SERVER = $(addprefix $(OUT),$(notdir $(SRC.SERVER:.cpp=$O)))
DESCRIPTION.$(SERVER.EXE) = $(DESCRIPTION.ndrvdem) (Server)

endif # ifeq ($(MAKESECTION),postdefines)

#------------------------------------------------------------------ targets ---#
ifeq ($(MAKESECTION),targets)

.PHONY: ndrvdem ndrvdemclean

all: $(CLIENT.EXE) $(SERVER.EXE)
ndrvdem: $(OUTDIRS) $(CLIENT.EXE) $(SERVER.EXE)
clean: ndrvdemclean

$(CLIENT.EXE): $(DEP.EXE) $(OBJ.CLIENT) \
  $(CSTOOLS.LIB) $(CSPARSER.LIB) $(CSSCRIPT.LIB) $(CSENGINE.LIB) \
  $(CSSNDLDR.LIB) $(CSGFXLDR.LIB) $(CSUTIL.LIB) \
  $(CSCOM.LIB) $(CSSYS.LIB) $(CSGEOM.LIB) $(CSINPUT.LIB) $(CSOBJECT.LIB)
	$(DO.LINK.EXE)

$(SERVER.EXE): $(DEP.EXE) $(OBJ.SERVER) \
  $(CSTOOLS.LIB) $(CSPARSER.LIB) $(CSSCRIPT.LIB) $(CSENGINE.LIB) \
  $(CSSNDLDR.LIB) $(CSGFXLDR.LIB) $(CSUTIL.LIB) \
  $(CSCOM.LIB) $(CSSYS.LIB) $(CSGEOM.LIB) $(CSINPUT.LIB) $(CSOBJECT.LIB)
	$(DO.LINK.EXE)

ndrvdemclean:
	-$(RM) $(CLIENT.EXE) $(SERVER.EXE)

ifdef DO_DEPEND
depend: $(OUTOS)ndrvdemo.dep
$(OUTOS)ndrvdemo.dep: $(SRC.CLIENT) $(SRC.SERVER)
	$(DO.DEP)
else
-include $(OUTOS)ndrvdemo.dep
endif

endif # ifeq ($(MAKESECTION),targets)
