/*
  Maze editor: text resources
  Copyright (C) 1998 by Jorrit Tyberghein
  Written by Andrew Zabolotny <bit@eltech.ru>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __ME_TEXT_H__

#define TEXT_ERROR			"Error"
#define TEXT_WARNING			"Warning"
#define TEXT_CREATEVERTEX		"Insert (create) vertice(-s)"
#define TEXT_DELETEVERTEX		"Delete vertice(-s)"
#define TEXT_CREATETRIANGLE		"Create a triangle"
#define TEXT_CREATESQUARE		"Create a square"
#define TEXT_CREATEHEXAGON		"Create a hexagon"
#define TEXT_CREATEOCTAGON		"Create a octagon"
#define TEXT_CREATENGON			"Create a polygon with N edges"
#define TEXT_CREATEBOX			"Create a 3D box"
#define TEXT_CREATEPRISM		"Create a prism"
#define TEXT_CREATEPYRAMID		"Create a pyramid"
#define TEXT_CREATETORUS		"Create a torus"
#define TEXT_CREATESPHERE		"Create a sphere"
#define TEXT_CREATELIGHT		"Create a light source"
#define TEXT_CREATEPOLYCONNECT		"Create polygon by connecting vertices"
#define TEXT_CREATEPOLYTRIFAN		"Create triangles in a fan"
#define TEXT_CREATEPOLYTRISTRIP		"Create triangles in a strip"
#define TEXT_CREATEPOLYQUADSTRIP	"Create quads in a strip"
#define TEXT_VERTEXSELECT		"Select vertices mode"
#define TEXT_VERTEXDESELECT		"Deselect vertices mode"
#define TEXT_VERTEXINVERT		"Invert vertices selection mode"
#define TEXT_POLYSELECT			"Select polygons mode"
#define TEXT_POLYCHG			"Edit polygon information"
#define TEXT_POLYDESELECT		"Deselect polygons mode"
#define TEXT_POLYINVERT			"Invert polygons selection mode"
#define TEXT_MOVESELECTED		"Move selected vertices/polygons"
#define TEXT_SCALE2DSELECTED		"Rescale selected vertices/polygons in 2D"
#define TEXT_SCALE3DSELECTED		"Rescale selected vertices/polygons in 3D"
#define TEXT_ROTATESELECTED		"Rotate selected vertices/polygons"
#define TEXT_SETUPMODIFYAXIS		"Click where you want modifications center/axis"
#define TEXT_COORDROTATE		"Rotate coordinate system with mouse"
#define TEXT_ZOOMINOUT			"Zoom view in (LMB) or out (RMB)"
#define TEXT_ZOOMTORECT			"Zoom view to rectangle"
#define TEXT_SLIDEVIEW			"Slide view with mouse (LMB)"

#define TEXT_PROCESS_CREATETRIANGLE	"Now enlarge and rotate the triangle"
#define TEXT_PROCESS_CREATESQUARE	"Now enlarge and rotate the square"
#define TEXT_PROCESS_CREATEHEXAGON	"Now enlarge and rotate the hexagon"
#define TEXT_PROCESS_CREATEOCTAGON	"Now enlarge and rotate the octagon"
#define TEXT_PROCESS_CREATENGON		"Now enlarge and rotate the %d-gon"
#define TEXT_PROCESS_CREATEPOLY		"Click next vertex to connect with (total: %d)"
#define TEXT_PROCESS_MOTION		"[X:%.3f Y:%.3f Z:%.3f] Move selected with mouse"
#define TEXT_PROCESS_SCALE		"[%.1f%%] Change scale by moving mouse horizontally"
#define TEXT_PROCESS_ROTATE		"[%d] Move mouse horizontally to change angle"
#define TEXT_PROCESS_CREATEBOX		"Define the front section of the box"
#define TEXT_PROCESS_CREATEBOXP2	"Now define the depth of the box [%.3f]"
#define TEXT_PROCESS_CREATEPRISM	"Define the base of the prism"
#define TEXT_PROCESS_CREATEPRISMP2	"Now define the depth of the prism [%.3f]"
#define TEXT_PROCESS_CREATEPYRAMID	"Define the base of the pyramid"
#define TEXT_PROCESS_CREATEPYRAMIDP2	"Now define the depth of the pyramid [%.3f]"
#define TEXT_PROCESS_CREATETORUS	"Define the outer diameter of torus [%.3f]"
#define TEXT_PROCESS_CREATETORUSP2	"Now define the inner diameter of torus [%.3f]"
#define TEXT_PROCESS_CREATESPHERE	"Define the diameter of sphere [%.3f]"

#define TEXT_TOOLBOXTITLE		"Tool box"
#define TEXT_INFOTITLE			"Information pane"
#define TEXT_WINDOWMANAGERTITLE		"Window manager"
#define TEXT_DRAFTVIEWTITLE		"Draft [%d]"
#define TEXT_3DVIEWTITLE		"Camera view"

#define	TEXT_SAVENULL			"Not valid file name"
#define TEXT_SAVEWORLDTITLE		"Save world as"
#define TEXT_SAVEMODELTITLE		"Save model as"
#define TEXT_SAVEBUTTON			"~Save"
#define TEXT_LOADWORLDTITLE		"Load world from"
#define TEXT_LOADMODELTITLE		"Merge model(s) from"
#define TEXT_LOADBUTTON			"~Load"
#define TEXT_OKAYBUTTON			"~Ok"
#define TEXT_CANCELBUTTON		"Cancel"

#define	TEXT_LOADTEXTURETITLE	"Load default texture file"

#define TEXT_VIEW_TOP			"top"
#define TEXT_VIEW_BOTTOM		"bottom"
#define TEXT_VIEW_LEFT			"left"
#define TEXT_VIEW_RIGHT			"right"
#define TEXT_VIEW_FRONT			"front"
#define TEXT_VIEW_BACK			"back"
#define TEXT_VIEW_ABSTRACT		"user"

#define TEXT_NODESKTOPSPACE		"Not enough desktop space\n"\
					"for another window"
#define TEXT_NOMODEL			"No current model defined\n"\
					"Please create one with\n"\
					"Model->Create->[...]"
#define TEXT_VERTEXALREADY		"There is already a vertex\n"\
					"at selected position"
#define TEXT_POLYALREADY		"There is already a polygon\n"\
					"connecting selected vertices"
#define TEXT_TOOMANYNEARVERT		"Too many vertices\n"\
					"near selected point"
#define TEXT_NOTENOUGHVERT		"Polygon should consist of\n"\
					"at least three vertices!"
#define TEXT_POLYERRUNDERFLOW		"Polygon has less than three vertices"
#define TEXT_POLYERROVERFLOW		"Polygon has too many vertices"
#define TEXT_POLYERRDUPVERTEX		"Polygon contains multiple\n"\
					"instances of same vertex"
#define TEXT_POLYERRNOPARENT		"Orphan polygon (no parent model)"
#define TEXT_POLYERRNONCOPLANAR		"Polygon vertices are not co-planar"
#define TEXT_POLYERRNONCONVEX		"Polygon is not convex"
#define TEXT_SAVEERROR			"There was an error detected\n"\
					"when saving. Possibly your\n"\
					"hard drive is out of free space"\
/*!!!!!!!!!!!!!!!!!!!!!!*/"note: for now saving rooms is not supported\nThis also can be the cause of error"
#define TEXT_CANTOPENWRITE		"Cannot open file for writing"
#define TEXT_CANTOPENREAD		"Cannot open file for reading"
#define TEXT_LOADFILEERROR		"There was an error loading file data"
#define TEXT_NOMODELFRAMES		"The type of current model\n"\
					"does not allow multiple frames"
#define TEXT_NOSELECTION		"The model does not have\n"\
					"any selected elements"

#define	TEXT_POLYGONINFO		"Edit polygon info."
#define TEXT_POLYNAME			"Name"
#define	TEXT_MIRROR				"Mirror"
#define	TEXT_TEXTURENAME		"Texture name"

#define TEXT_CLEARMODELTITLE		"Clear what?"
#define TEXT_REMOVEVERTICES		"Remove all ~vertices"
#define TEXT_REMOVEFACES		"Remove all ~faces"
#define TEXT_REMOVELIGHTS		"Remove all ~lights"
#define TEXT_REMOVEFRAMES		"Remove all f~rames"
#define TEXT_REMOVEACTIONS		"Remove all ~actions"

#define TEXT_MODIFYAXISTITLE		"Select modification axis location"
#define TEXT_AXIS2DLOCATION		"2D location"
#define TEXT_AXISTOPLEFT		"Top-Left"
#define TEXT_AXISTOPCENTER		"~Top-Center"
#define TEXT_AXISTOPRIGHT		"Top-Right"
#define TEXT_AXISLEFT			"~Left"
#define TEXT_AXISCENTER			"~Center"
#define TEXT_AXISRIGHT			"~Right"
#define TEXT_AXISBOTTOMLEFT		"Bottom-Left"
#define TEXT_AXISBOTTOMCENTER		"~Bottom-Center"
#define TEXT_AXISBOTTOMRIGHT		"Bottom-Right"
#define TEXT_AXISUSERDEFINED		"~User-Defined:"
#define TEXT_AXIS3DLOCATION		"3D location"
#define TEXT_AXISVIEWPLANE		"~Viewplane"
#define TEXT_AXISNEAR			"~Near"
#define TEXT_AXISCENTERED		"Centere~d"
#define TEXT_AXISFAR			"~Far"
#define TEXT_AXISONLYSELECTION		"Consider only ~selection"
#define TEXT_DEFINEBUTTON		"~Define"

#define TEXT_ENTERSIDES			"~# sides"
#define TEXT_NGONSIDESTITLE		"N-gon sides"
#define TEXT_PRISMSIDESTITLE		"Prism sides"
#define TEXT_PYRAMIDSIDESTITLE		"Pyramid sides"
#define TEXT_TORUSDETAILTITLE		"Detail level"
#define TEXT_RADIALDETAILVALUE		"~Radial"
#define TEXT_CROSSDETAILVALUE		"~Cross"
#define TEXT_SPHEREDETAILTITLE		"Sphere detail level"
#define TEXT_SPHEREDETAILVALUE		"~Detail level"

#define TEXT_PLEASEWAITTITLE		"Please wait"
#define TEXT_PLEASESTANDBY		"Please stand by while"
#define TEXT_SAVINGWORLD		"saving world file ..."

#define TEXT_LOADINGWORLDFILE		"Loading world file: %s\n"
#define TEXT_IMPORTINGTEXTURES		"Importing textures ...\n"
#define TEXT_IMPORTINGROOMS		"Importing rooms ...\n"
#define TEXT_IMPORTINGTHINGS		"Importing things ...\n"
#define TEXT_IMPORTINGSPRITES		"Importing sprites ...\n"

#define TEXT_MODELMANAGERTITLE		"Model manager"
#define TEXT_MODELLIST			"~Model list"
#define TEXT_ROOMSRADIOBUT		"~Rooms"
#define TEXT_SECTORSRADIOBUT		"~Sectors"
#define TEXT_THINGSRADIOBUT		"~Things"
#define TEXT_SPRITESRADIOBUT		"~Sprites"
#define TEXT_SELECTBUTTON		"Se~lect"
#define TEXT_CREATEBUTTON		"~Create"
#define TEXT_PROPERTIESBUTTON		"~Properties"
#define TEXT_DELETEBUTTON		"~Delete"
#define TEXT_SUREDELETEMODEL		"Are you sure you want to\n"\
					"delete selected model?"

#define TEXT_LIGHTDETAILTITLE		"Light Detail "
#define TEXT_LIGHTRADIUSVALUE		"~Radius"
#define TEXT_REDCOLORVALUES		"~RED"
#define TEXT_GREENCOLORVALUES		"~BLUE"
#define TEXT_BLUECOLORVALUES		"~GREEN"

#define TEXT_PORTALTITLE		"Portal Design "
#define TEXT_PORTALSELECT		"Automatic Portal Design "
#define	TEXT_NOTVALIDPORTAL		"Not valid portal configuration! \nMust be two sectors each with one polygon." 
#define	TEXT_POLYGONLIST		"Polygons "
#define	TEXT_SECTORLIST			"Rooms "

#define TEXT_DRAFTSETUPTITLE		"Draft View Setup"
#define TEXT_DRAFTSETUPGADGETS		"Gadgets"
#define TEXT_DRAFTSETUPCOORDAXIES	"~Coordinate axes"
#define TEXT_DRAFTSETUPGRID		"~Grid"
#define TEXT_DRAFTSETUPMODIFYCENTER	"~Modification center"
#define TEXT_DRAFTSETUPDRAW		"Draw"
#define TEXT_DRAFTSETUPVERTCROSSES	"~Vertices as crosses"
#define TEXT_DRAFTSETUPINACTIVEROOMS	"~Inactive rooms"
#define TEXT_DRAFTSETUPSNAPTOGRID	"~Snap to grid"
#define TEXT_DRAFTSETUPPICKDISTANCE	"~Pick distance"
#define TEXT_DRAFTSETUPGRIDSPACING	"Grid sp~acing"

#endif // __ME_TEXT_H__
