/*
  Maze editor: 3D model class
  Copyright (C) 1998 by Jorrit Tyberghein
  Written by Andrew Zabolotny <bit@eltech.ru>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "sysdef.h"
#include "me_spact.h"
#include "csutil/util.h"

//-----------------------------------------------// Sprite Action class //----//

mzSpriteAction::mzSpriteAction (csSpriteAction *iAction) : Names (8, 8),
  Delays (8, 8)
{
  Name = strnew (iAction->GetName ());
  int Frames = iAction->GetNumFrames ();
  for (int i = 0; i < Frames; i++)
  {
    csFrame *f = iAction->GetFrame (i);
    int d = iAction->GetFrameDelay (i);
    int frames = Names.Length ();
    Names.Push (strnew (f->GetName ()));
    if (frames != Names.Length ())
      Delays.Push ((void *)d);
  } /* endfor */
}

mzSpriteAction::~mzSpriteAction ()
{
  if (Name)
    delete [] Name;
}

void mzSpriteAction::NotifyFrameDeleted (char *iFrameName)
{
  for (int i = Names.Length () - 1; i >= 0; i--)
    if (strcmp (iFrameName, (char *)Names [i]) == 0)
    {
      Names.Delete (i);
      Delays.Delete (i);
    } /* endif */
}

bool mzSpriteAction::operator == (const mzSpriteAction &a)
{
  if (Frames () != a.Frames ())
    return false;
  if (strcmp (Name, a.Name))
    return false;
  int i;
  for (i = Frames () - 1; i >= 0; i--)
  {
    if (Delay (i) != a.Delay (i))
      return false;
    if (FrameName (i) != a.FrameName (i))
      return false;
  } /* endfor */
  return true;
}

bool mzSpriteAction::SetFrameName (int iFrame, char *iName)
{
  if ((iFrame < 0) || (iFrame > Frames ()))
    return false;
  if (Names [iFrame])
    delete [] FrameName (iFrame);
  Names [iFrame] = strnew (iName);
  return true;
}
