/*
  Maze editor: menu resources
  Copyright (C) 1998 by Jorrit Tyberghein
  Written by Andrew Zabolotny <bit@eltech.ru>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "sysdef.h"
#include "me_res.h"
#include "me_app.h"

void InitializeMainMenu (csApp *app)
{
  csMenu *menu, *submenu, *subsubmenu, *subsubsubmenu;

  CHK (menu = new csMenu (app, csmfsBar, 0));
  menu->id = CSWID_MENUBAR;

  CHK (submenu = new csMenu (NULL));
  CHK ((void)new csMenuItem (menu, "~File", submenu));
    CHK (subsubmenu = new csMenu (NULL));
    CHK ((void)new csMenuItem (submenu, "~Open", subsubmenu));
      CHK ((void)new csMenuItem (subsubmenu, "~World\tCtrl+O", cscmdMzOpenWorld));
      CHK ((void)new csMenuItem (subsubmenu, "~Model\tCtrl+Shift+O", cscmdMzOpenModel));
    CHK (subsubmenu = new csMenu (NULL));
    CHK ((void)new csMenuItem (submenu, "~Save", subsubmenu));
      CHK ((void)new csMenuItem (subsubmenu, "~World\tCtrl+S", cscmdMzSaveWorld));
      CHK ((void)new csMenuItem (subsubmenu, "~Model\tCtrl+Shift+S", cscmdMzSaveModel));
    CHK ((void)new csMenuItem (submenu, "~New world", cscmdNewWorld));
    CHK ((void)new csMenuItem (submenu));
    CHK ((void)new csMenuItem (submenu, "~Quit\tShift+Q", cscmdQuit));

  CHK (submenu = new csMenu (NULL));
  CHK ((void)new csMenuItem (menu, "~Edit", submenu));
    CHK ((void)new csMenuItem (submenu, "~Undo\tAlt+BackSpace", cscmdNothing));
    CHK ((void)new csMenuItem (submenu));
    CHK ((void)new csMenuItem (submenu, "~Copy\tCtrl+Ins", cscmdNothing));
    CHK ((void)new csMenuItem (submenu, "Cu~t\tShift+Del", cscmdNothing));
    CHK ((void)new csMenuItem (submenu, "~Paste\tShift+Ins", cscmdNothing));
    CHK ((void)new csMenuItem (submenu));
    CHK (subsubmenu = new csMenu (NULL));
    CHK ((void)new csMenuItem (submenu, "~Select", subsubmenu));
      CHK (subsubsubmenu = new csMenu (NULL));
      CHK ((void)new csMenuItem (subsubmenu, "~Vertex", subsubsubmenu));
        CHK ((void)new csMenuItem (subsubsubmenu, "~All\tCtrl+'+'", cscmdMzVertexSelectAll));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Deselect all\tCtrl+'-'", cscmdMzVertexDeselectAll));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Invert all\tCtrl+'*'", cscmdMzVertexInvertAll));
        CHK ((void)new csMenuItem (subsubsubmenu, "Select mode\t+", cscmdMzVertexSelect));
        CHK ((void)new csMenuItem (subsubsubmenu, "Deselect mode\t-", cscmdMzVertexDeselect));
        CHK ((void)new csMenuItem (subsubsubmenu, "Invert mode\t*", cscmdMzVertexInvert));
      CHK (subsubsubmenu = new csMenu (NULL));
      CHK ((void)new csMenuItem (subsubmenu, "~Polygon", subsubsubmenu));
        CHK ((void)new csMenuItem (subsubsubmenu, "~All\tCtrl+Shift+'+'", cscmdMzPolySelectAll));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Deselect all\tCtrl+Shift+'-'", cscmdMzPolyDeselectAll));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Invert all\tCtrl+Shift+'*'", cscmdMzPolyInvertAll));
        CHK ((void)new csMenuItem (subsubsubmenu, "Select mode\tShift+'+'", cscmdMzPolySelect));
        CHK ((void)new csMenuItem (subsubsubmenu, "Deselect mode\tShift+'-'", cscmdMzPolyDeselect));
        CHK ((void)new csMenuItem (subsubsubmenu, "Invert mode\tShift+'*'", cscmdMzPolyInvert));
        CHK ((void)new csMenuItem (subsubsubmenu, "Edit Polygon info.\tShift+'/'", cscmdMzPolyChg));
      CHK (subsubsubmenu = new csMenu (NULL));
      CHK ((void)new csMenuItem (subsubmenu, "P~ortal\tCtrl+Shift+'o'", cscmdMzPortalDefine));
      CHK ((void)new csMenuItem (subsubmenu, "A~uto Portal\tCtrl+Shift+'u'", cscmdMzPortalSelect));
    CHK (subsubmenu = new csMenu (NULL));
    CHK ((void)new csMenuItem (submenu, "C~reate", subsubmenu));
      CHK (subsubsubmenu = new csMenu (NULL));
      CHK ((void)new csMenuItem (subsubmenu, "~Vertex", subsubsubmenu));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Insert\tIns", cscmdMzCreateVertex));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Delete\tDel", cscmdMzDeleteVertex));
      CHK (subsubsubmenu = new csMenu (NULL));
      CHK ((void)new csMenuItem (subsubmenu, "~2D preset", subsubsubmenu));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Triangle", cscmdMzCreateTriangle));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Square", cscmdMzCreateSquare));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Hexagon", cscmdMzCreateHexagon));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Octagon", cscmdMzCreateOctagon));
        CHK ((void)new csMenuItem (subsubsubmenu, "~N-gon", cscmdMzCreateNgon));
      CHK (subsubsubmenu = new csMenu (NULL));
      CHK ((void)new csMenuItem (subsubmenu, "~3D preset", subsubsubmenu));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Box", cscmdMzCreateBox));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Prism", cscmdMzCreatePrism));
        CHK ((void)new csMenuItem (subsubsubmenu, "P~yramid", cscmdMzCreatePyramid));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Torus", cscmdMzCreateTorus));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Sphere", cscmdMzCreateSphere));
      CHK (subsubsubmenu = new csMenu (NULL));
      CHK ((void)new csMenuItem (subsubmenu, "~Polygon", subsubsubmenu));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Connect\tCtrl+Ins", cscmdMzCreatePolyConnect));
        CHK ((void)new csMenuItem (subsubsubmenu, "Triangle ~fan\tCtrl+Alt+Ins", cscmdMzCreatePolyTriFan));
        CHK ((void)new csMenuItem (subsubsubmenu, "Triangle ~strip\tCtrl+Shift+Ins", cscmdMzCreatePolyTriStrip));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Quad strip\tCtrl+Alt+Shift+Ins", cscmdMzCreatePolyQuadStrip));
      CHK ((void)new csMenuItem (subsubmenu, "~Light", cscmdMzCreateLight));
    CHK (subsubmenu = new csMenu (NULL));
    CHK ((void)new csMenuItem (submenu, "~Modify", subsubmenu));
      CHK (subsubsubmenu = new csMenu (NULL));
      CHK ((void)new csMenuItem (subsubmenu, "~Selected", subsubsubmenu));
        CHK ((void)new csMenuItem (subsubsubmenu, "Delete ~vertices\tCtrl+Del", cscmdMzDeleteSelVertices));
        CHK ((void)new csMenuItem (subsubsubmenu, "Delete ~polygons\tCtrl+Shift+Del", cscmdMzDeleteSelPolygons));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Move\tm", cscmdMzMove));
        CHK ((void)new csMenuItem (subsubsubmenu, "~2D scale\ts", cscmdMzScale2D));
        CHK ((void)new csMenuItem (subsubsubmenu, "~3D scale\td", cscmdMzScale3D));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Rotate\tr", cscmdMzRotate));
      CHK (subsubsubmenu = new csMenu (NULL));
      CHK ((void)new csMenuItem (subsubmenu, "~Light", subsubsubmenu));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Move", cscmdNothing));
        CHK ((void)new csMenuItem (subsubsubmenu, "~Delete", cscmdNothing));
      CHK ((void)new csMenuItem (subsubmenu, "A~xis\tx", cscmdMzSetupAxis));

  CHK (submenu = new csMenu (NULL));
  CHK ((void)new csMenuItem (menu, "~Model", submenu));
    CHK (subsubmenu = new csMenu (NULL));
    CHK ((void)new csMenuItem (submenu, "~Create", subsubmenu));
      CHK ((void)new csMenuItem (subsubmenu, "~Room", cscmdMzCreateRoom));
      CHK ((void)new csMenuItem (subsubmenu, "~Sector", cscmdMzCreateSector));
      CHK ((void)new csMenuItem (subsubmenu, "~Thing", cscmdMzCreateThing));
      CHK ((void)new csMenuItem (subsubmenu, "~Sprite", cscmdMzCreateSprite));
    CHK ((void)new csMenuItem (submenu, "~Properties", cscmdMzModelProperties));
    CHK ((void)new csMenuItem (submenu));
    CHK ((void)new csMenuItem (submenu, "~Manager\tCtrl+M", cscmdMzModelManager));
    CHK ((void)new csMenuItem (submenu, "C~lear", cscmdMzClearModel));
    CHK ((void)new csMenuItem (submenu, "~Delete", cscmdMzDeleteModel));
    CHK ((void)new csMenuItem (submenu));
    CHK (subsubmenu = new csMenu (NULL));
    CHK ((void)new csMenuItem (submenu, "~Frame", subsubmenu));
      CHK ((void)new csMenuItem (subsubmenu, "~Insert", cscmdMzInsertModelFrame));
      CHK ((void)new csMenuItem (subsubmenu, "~Delete", cscmdMzDeleteModelFrame));
      CHK ((void)new csMenuItem (subsubmenu, "~Next\tCtrl+Up", cscmdMzNextModelFrame));
      CHK ((void)new csMenuItem (subsubmenu, "~Previous\tCtrl+Down", cscmdMzPrevModelFrame));

  CHK (submenu = new csMenu (NULL));
  CHK ((void)new csMenuItem (menu, "~Window", submenu));
    CHK ((void)new csMenuItem (submenu, "Close ~all", cscmdMzWindowCloseAll));
    CHK ((void)new csMenuItem (submenu));
    CHK (subsubmenu = new csMenu (NULL));
    CHK ((void)new csMenuItem (submenu, "~Draft view", subsubmenu));
      CHK ((void)new csMenuItem (subsubmenu, "~Create", cscmdMzDraftView));
      CHK ((void)new csMenuItem (subsubmenu, "~Setup\tCtrl+D", cscmdMzDraftViewSetup));
    CHK (subsubmenu = new csMenu (NULL));
    CHK ((void)new csMenuItem (submenu, "~3D view", subsubmenu));
      CHK ((void)new csMenuItem (subsubmenu, "~Create", cscmdMz3DView));
      CHK ((void)new csMenuItem (subsubmenu, "~Setup\tCtrl+V", cscmdMz3DViewSetup));
    CHK (subsubmenu = new csMenu (NULL));
    CHK ((void)new csMenuItem (submenu, "~Toolbar", subsubmenu));
      CHK ((void)new csMenuItem (subsubmenu, "~Tool box", cscmdMzToolBox));
      CHK ((void)new csMenuItem (subsubmenu, "~Window manager", cscmdMzWindowManager));
      CHK ((void)new csMenuItem (subsubmenu, "~Information", cscmdMzInformation));
    CHK ((void)new csMenuItem (submenu));
    CHK (subsubmenu = new csMenu (NULL));
    CHK ((void)new csMenuItem (submenu, "~Layout", subsubmenu));
      CHK ((void)new csMenuItem (subsubmenu, "~1: One\tCtrl+1", cscmdMzWindowLayout1));
      CHK ((void)new csMenuItem (subsubmenu, "~2: Two\tCtrl+2", cscmdMzWindowLayout2));
      CHK ((void)new csMenuItem (subsubmenu, "~3: Three\tCtrl+3", cscmdMzWindowLayout3));
      CHK ((void)new csMenuItem (subsubmenu, "~4: Four\tCtrl+4", cscmdMzWindowLayout4));
      CHK ((void)new csMenuItem (subsubmenu));
      CHK ((void)new csMenuItem (subsubmenu, "~Reset", cscmdMzWindowLayoutReset));
    CHK ((void)new csMenuItem (submenu));
    CHK ((void)new csMenuItem (submenu, "L~ist", cscmdMzWindowList));

  CHK ((void)new csMenuItem (menu, CSMIS_NEWCOLUMN));

  CHK (submenu = new csMenu (NULL));
  CHK ((void)new csMenuItem (menu, "~Help", submenu));
    CHK ((void)new csMenuItem (submenu, "~Index", cscmdNothing));
    CHK ((void)new csMenuItem (submenu, "~General", cscmdNothing));
    CHK ((void)new csMenuItem (submenu, "~Context\tF1", cscmdNothing));
    CHK ((void)new csMenuItem (submenu));
    CHK ((void)new csMenuItem (submenu, "~About", cscmdMzAbout));

  menu->PlaceItems ();
  menu->SetRect (0, 0, app->bound.xmax, menu->TextHeight () + 8);
}

void InitializeKeyboardAccelerator (csApp *app)
{
  CHK (csKeyboardAccelerator *ka = new csKeyboardAccelerator (app));
  ka->id = MZID_ACCELERATOR;
  ka->Command ('Q', CSMASK_SHIFT, cscmdQuit);
  ka->Command ('+', CSMASK_CTRL, cscmdMzVertexSelectAll);
  ka->Command ('-', CSMASK_CTRL, cscmdMzVertexDeselectAll);
  ka->Command ('*', CSMASK_CTRL, cscmdMzVertexInvertAll);
  ka->Command ('+', 0, cscmdMzVertexSelect);
  ka->Command ('-', 0, cscmdMzVertexDeselect);
  ka->Command ('*', 0, cscmdMzVertexInvert);
  ka->Command ('+', CSMASK_CTRL | CSMASK_SHIFT, cscmdMzPolySelectAll);
  ka->Command ('_', CSMASK_CTRL | CSMASK_SHIFT, cscmdMzPolyDeselectAll);
  ka->Command ('*', CSMASK_CTRL | CSMASK_SHIFT, cscmdMzPolyInvertAll);
  ka->Command ('o', CSMASK_CTRL | CSMASK_SHIFT, cscmdMzPortalDefine);
  ka->Command ('u', CSMASK_CTRL | CSMASK_SHIFT, cscmdMzPortalSelect);
  ka->Command ('+', CSMASK_SHIFT, cscmdMzPolySelect);
  ka->Command ('_', CSMASK_SHIFT, cscmdMzPolyDeselect);
  ka->Command ('*', CSMASK_SHIFT, cscmdMzPolyInvert);
  ka->Command ('/', CSMASK_SHIFT, cscmdMzPolyChg);
  ka->Command (CSKEY_INS, 0, cscmdMzCreateVertex);
  ka->Command (CSKEY_DEL, 0, cscmdMzDeleteVertex);
  ka->Command (CSKEY_INS, CSMASK_CTRL, cscmdMzCreatePolyConnect);
  ka->Command (CSKEY_INS, CSMASK_CTRL | CSMASK_ALT, cscmdMzCreatePolyTriFan);
  ka->Command (CSKEY_INS, CSMASK_CTRL | CSMASK_SHIFT, cscmdMzCreatePolyTriStrip);
  ka->Command (CSKEY_INS, CSMASK_CTRL | CSMASK_SHIFT | CSMASK_ALT, cscmdMzCreatePolyQuadStrip);
  ka->Command ('1', CSMASK_CTRL, cscmdMzWindowLayout1);
  ka->Command ('2', CSMASK_CTRL, cscmdMzWindowLayout2);
  ka->Command ('3', CSMASK_CTRL, cscmdMzWindowLayout3);
  ka->Command ('4', CSMASK_CTRL, cscmdMzWindowLayout4);
  ka->Command (CSKEY_DEL, CSMASK_CTRL, cscmdMzDeleteSelVertices);
  ka->Command (CSKEY_DEL, CSMASK_CTRL | CSMASK_SHIFT, cscmdMzDeleteSelPolygons);
  ka->Command ('o', CSMASK_CTRL, cscmdMzOpenWorld);
  ka->Command ('O', CSMASK_CTRL | CSMASK_SHIFT, cscmdMzOpenModel);
  ka->Command ('s', CSMASK_CTRL, cscmdMzSaveWorld);
  ka->Command ('S', CSMASK_CTRL | CSMASK_SHIFT, cscmdMzSaveModel);
  ka->Command ('m', CSMASK_CTRL, cscmdMzModelManager);
  ka->Command ('d', CSMASK_CTRL, cscmdMzDraftViewSetup);
  ka->Command ('v', CSMASK_CTRL, cscmdMz3DViewSetup);

  ka->Command ('m', 0, cscmdMzMove);
  ka->Command ('s', 0, cscmdMzScale2D);
  ka->Command ('d', 0, cscmdMzScale3D);
  ka->Command ('r', 0, cscmdMzRotate);
  ka->Command ('x', 0, cscmdMzSetupAxis);

  ka->Command (CSKEY_UP, CSMASK_CTRL, cscmdMzNextModelFrame);
  ka->Command (CSKEY_DOWN, CSMASK_CTRL, cscmdMzPrevModelFrame);

  ka->Broadcast (CSKEY_HOME, 0, cscmdMzDraftViewOrigin);
  ka->Broadcast (CSKEY_HOME, CSMASK_CTRL, cscmdMzDraftViewFit);
}
