/*
  Maze editor: Additional dialog box definitions
  Copyright (C) 1998 by Jorrit Tyberghein
  Written by Siu-hang Or <shor@cse.cuhk.edu.hk>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "sysdef.h"
#include "me_res.h"
#include "me_text.h"
#include "me_app.h"
#include "me_util.h"
#include "csutil/scanstr.h"
#include "csobject/nameobj.h"

#define	SYSTEM_TEX_NO		9
#define MZWID_POLYNAME		0xc0000000
#define MZWID_MIRROR		0xc0000001
#define MZWID_ALPHA			0xc0000002
#define MZWID_TEXTURELIST	0xc0000003
#define MZWID_FRAMES		0xc0000004
#define MZWID_ACTIONS		0xc0000005
// [x]=====Polygon Info.?===[x][x]
// |                             |
// | Name :		xxxxxxx			 |
// | mirror[x]	Alpha ___-/+	 |
// | Texture --------------|	 |
// |         |			   |	 |
// |		 |			   |	 |
// |		 |			   |     |
// |          -------------		 |
// |    [ Ok ] [ Cancel ]		 |
// +-----------------------------+
int PolygonInfoDialog (csApp *iApp, mz3DPolygon& sel_poly)
{
//  bool ioRemoveVertices, ioRemoveFaces, ioRemoveLights, ioRemoveFrames, ioRemoveActions;


  CHK (csWindow *w = new csWindow (iApp, TEXT_POLYGONINFO,
    CSWS_BUTSYSMENU | CSWS_BUTCLOSE | CSWS_TITLEBAR));
  CHK (csDialog *d = new csDialog (w));
  w->SetDragStyle (w->GetDragStyle () & ~CS_DRAG_SIZEABLE);

  //char strbuff [81];
  
  CHK (csInputLine *il = new csInputLine (d, 80, csifsThinRect));
  il->SetRect (50, 6, 250, 18);
  il->id = MZWID_POLYNAME;
  il->SetText (sel_poly.Name);
  CHK (csComponent *c = new csStatic (d, il, TEXT_POLYNAME));
  c->SetPos (5, 8);

  CHK (c = new csCheckBox (d, MZWID_MIRROR));
  c->SetPos (5, 22);
  c->SendCommand (cscmdCheckBoxSet, (void *)sel_poly.mirror);
  CHK (c = new csStatic (d, c, TEXT_MIRROR));
  c->SetPos (21, 24);

  CHK (csSpinBox *sb = new csSpinBox (d));
  sb->SetRect (145, 20, 224, 36);
  sb->id = MZWID_ALPHA;
  sb->SetLimits (0, 100);
  sb->SetValue (int(sel_poly.alpha));

  CHK (csStatic *s = new csStatic (d, sb, "Alpha"));
  s->SetPos (95, 24);

  csTextureHandle *tp = sel_poly.Texture;
  CHK (c = new csStatic (d, c, (char *)csNameObject::GetName(*tp)));
  c->SetPos (100, 38);

  CHK (c = new csStatic (d, c, TEXT_TEXTURENAME));
  c->SetFont (csFontPolice); c->SetPos (5, 40);

  // Query the used textures
  csStrVector TexNameList (8, 8);
//  ((MazeEditor*)iApp)->GetUsedTextures (Tex, true);
	  csTextureList *texList = iApp->GetTextures ();
	  if (texList != NULL) {
		  for (int i=0; i<texList->GetNumTextures(); i++) {
			  csTextureHandle *tex = texList->GetTextureMM(i);
			  TexNameList.Push (strnew ((char *)csNameObject::GetName(*tex)));
		  }
	  }
	
  csListBoxItem *act=NULL;

  CHK (csListBox *lb1 = new csListBox (d, CSLBS_VSCROLL, cslfsThickRect));
  lb1->SetRect (100, 38, 250, 180);
  lb1->id = MZWID_TEXTURELIST;

  // List all the selected polygons in the world
  lb1->SendCommand (cscmdListBoxClear, NULL);
  {
	// we skip the system texture, which has 9 pieces
    for (int i = SYSTEM_TEX_NO; i < TexNameList.Length (); i++)
	{
		char *cp = (char *)TexNameList[i];
		CHK (csListBoxItem *lbi = new csListBoxItem (lb1, cp , i+1, 
			strcmp((const char *)TexNameList[i], csNameObject::GetName(*tp))  ? cslisEmphasized : cslisNormal));
      if (!strcmp((const char *)TexNameList[i], csNameObject::GetName(*tp)))
        act = lbi;

	}
  } /* endfor */

  if (act)
    act->SendCommand (cscmdListBoxItemSet, (void *)true);

  lb1->PlaceItems();
  
  lb1->SetState (CSS_GROUP, true);

  CHK (csButton *b = new csButton (d, cscmdOK, CSBS_DEFAULTVALUE | CSBS_DISMISS | CSBS_DEFAULT));
  b->SetText (TEXT_OKAYBUTTON);
  b->SetSuggestedSize (+16, +2);
  b->SetPos (20, 220);
  b->SetState (CSS_GROUP, true);

  CHK (b = new csButton (d, cscmdCancel, CSBS_DEFAULTVALUE | CSBS_DISMISS));
  b->SetText (TEXT_CANCELBUTTON);
  b->SetSuggestedSize (+16, +2);
  b->SetPos (80, 220);

  // and now set window size and center it.
  w->SetSize (300, 300);
//  CenterOnMouse (iApp, w);

  int retcode = iApp->Execute (w);
  if (retcode == cscmdOK)
  {
    if (sel_poly.mirror = (d->GetChild (MZWID_MIRROR)->SendCommand (cscmdCheckBoxQuery) != NULL))
		// we have mirror effect 
		sel_poly.portal = strnew(sel_poly.parent->Name);
    sel_poly.alpha  = (int)d->GetChild (MZWID_ALPHA)->SendCommand (cscmdSpinBoxQueryValue);
    sel_poly.SetName(d->GetChild (MZWID_POLYNAME)->GetText());
    csListBoxItem *lbi = (csListBoxItem *)(d->GetChild (MZWID_TEXTURELIST)->SendCommand (cscmdListBoxQueryFirstSelected));
    if (lbi)
    {
//	  char *cp = (char *)TexNameList[lbi->id-1];
	  // changing texture for the polygon
	  csTextureHandle *tex = texList->GetTextureMM(lbi->id-1);
	  sel_poly.Texture = tex;
			
//	  System->Printf (MSG_INITIALIZATION, "Change texture into %s\n", cp);
	  
	}
  }
  delete w;
  return retcode;
}

