/*
  Maze editor: user command codes
  Copyright (C) 1998 by Jorrit Tyberghein
  Written by Andrew Zabolotny <bit@eltech.ru>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __ME_CMDS_H__
#define __ME_CMDS_H__

enum
{
  /// Show the "about" dialog box
  cscmdMzAbout = 0x80000000,
  /// Pop up window list
  cscmdMzWindowList,

  /// Add the "tool box" toolbar
  cscmdMzToolBox,
  /// Add the "window manager" toolbar
  cscmdMzWindowManager,
  /// Add the "information" toolbar
  cscmdMzInformation,
  /// Add the "draft view" window
  cscmdMzDraftView,
  /// Setup the Draft View windows
  cscmdMzDraftViewSetup,
  /// Add the "3D view" window
  cscmdMz3DView,
  /// Setup the "3D view" windows
  cscmdMz3DViewSetup,

  /// Vertex operations
  cscmdMzVertex,
  /// Create a vertex
  cscmdMzCreateVertex,
  /// Delete a vertex
  cscmdMzDeleteVertex,
  /// Delete selected vertices
  cscmdMzDeleteSelVertices,
  /// Delete selected polygons
  cscmdMzDeleteSelPolygons,

  /// Portal definition
  cscmdMzPortalDefine,

  /// Create 2D object
  cscmdMzCreate2D,
  /// Create a triangular polygon
  cscmdMzCreateTriangle,
  /// Create a square polygon
  cscmdMzCreateSquare,
  /// Create a hexagonal polygon
  cscmdMzCreateHexagon,
  /// Create a octagonal polygon
  cscmdMzCreateOctagon,
  /// Create a polygon with N vertices
  cscmdMzCreateNgon,

  /// Create 3D object
  cscmdMzCreate3D,
  /// Create a 3D box
  cscmdMzCreateBox,
  /// Create a prism
  cscmdMzCreatePrism,
  /// Create a pyramid
  cscmdMzCreatePyramid,
  /// Create a torus
  cscmdMzCreateTorus,
  /// Create a sphere
  cscmdMzCreateSphere,

  /// Create light source
  cscmdMzCreateLight,

  /// Create polygon(s)
  cscmdMzCreatePoly,
  /// Create polygon(s) by selecting each vertex of polygon
  cscmdMzCreatePolyConnect,
  /// Create a triangle fan
  cscmdMzCreatePolyTriFan,
  /// Create a triangle strip
  cscmdMzCreatePolyTriStrip,
  /// Create a square strip
  cscmdMzCreatePolyQuadStrip,

  /// Select/deselct vertices or polygons
  cscmdMzSelect,
  /// Activate vertex selection mode
  cscmdMzVertexSelect,
  /// Activate vertex deselection mode
  cscmdMzVertexDeselect,
  /// Activate vertex inversion mode
  cscmdMzVertexInvert,
  /// Activate polygon selection mode
  cscmdMzPolySelect,
  /// Activate polygon deselection mode
  cscmdMzPolyDeselect,
  /// Activate polygon inversion mode
  cscmdMzPolyInvert,
  /// Change information on a selected polygon
  cscmdMzPolyChg,

  /// Select all vertices
  cscmdMzVertexSelectAll,
  /// Deselect all vertices
  cscmdMzVertexDeselectAll,
  /// Invert all vertices
  cscmdMzVertexInvertAll,
  /// Select all polygons
  cscmdMzPolySelectAll,
  /// Deselect all polygons
  cscmdMzPolyDeselectAll,
  /// Invert all polygons
  cscmdMzPolyInvertAll,
  /// Automatic portal selection
  cscmdMzPortalSelect,

  /// Modify selected vertices/polygons
  cscmdMzModify,
  /// Move selected vertices/polygons
  cscmdMzMove,
  /// Scale in 2D selected vertices/polygons
  cscmdMzScale2D,
  /// Scale in 3D selected vertices/polygons
  cscmdMzScale3D,
  /// Rotate selected vertices/polygons
  cscmdMzRotate,
  /// Setup rotation/scale axis
  cscmdMzSetupAxis,

  /// Switch to 1st window layout
  cscmdMzWindowLayout1,
  /// Switch to 2nd window layout
  cscmdMzWindowLayout2,
  /// Switch to 3rd window layout
  cscmdMzWindowLayout3,
  /// Switch to 4rth window layout
  cscmdMzWindowLayout4,
  /// Close all windows
  cscmdMzWindowCloseAll,
  /// Reset window layout to default
  cscmdMzWindowLayoutReset,
  /// Rotate coordinate system in active window
  cscmdMzCoordRotate,
  /// Zoom in / out
  cscmdMzZoomInOut,
  /// Toggle grid
  cscmdMzToggleGrid,
  /// Toggle coordinate axes
  cscmdMzToggleAxis,
  /// Zoom view to rectangle
  cscmdMzZoomToRect,
  /// Slide view (panning)
  cscmdMzSlideView,

  /// Create new model and set its type to "room"
  cscmdMzCreateRoom,
  /// Create new model and set its type to "room"
  cscmdMzCreateSector,
  /// Create new model and set its type to "thing"
  cscmdMzCreateThing,
  /// Create new model and set its type to "sprite"
  cscmdMzCreateSprite,
  /// Bring up model properties dialog box
  cscmdMzModelProperties,
  /// Select the model for editing
  cscmdMzModelManager,
  /// Clear current model
  cscmdMzClearModel,
  /// Delete current model
  cscmdMzDeleteModel,
  /// Switch to next model frame
  cscmdMzNextModelFrame,
  /// Switch to previous model frame
  cscmdMzPrevModelFrame,
  /// Insert a new frame into current model
  cscmdMzInsertModelFrame,
  /// Delete current frame from current model
  cscmdMzDeleteModelFrame,

  /// "Model has been changed" global notification
  cscmdMzModelChangeNotify,
  /// "Draft Editor parameters has been changed" global notification
  cscmdMzDraftChangeNotify,

  /// Draft view titlebar buttons command codes
  /// Show top view
  cscmdMzDraftViewTop,
  /// Show bottom view
  cscmdMzDraftViewBottom,
  /// Show left view
  cscmdMzDraftViewLeft,
  /// Show right view
  cscmdMzDraftViewRight,
  /// Show front view
  cscmdMzDraftViewFront,
  /// Show backward view
  cscmdMzDraftViewBack,
  /// Fit current model into window
  cscmdMzDraftViewFit,
  /// Center origin in window
  cscmdMzDraftViewOrigin,

  /// Open a new world file
  cscmdMzOpenWorld,
  /// Save world file
  cscmdMzSaveWorld,
  /// Open a model (add it to current world)
  cscmdMzOpenModel,
  /// Save current model
  cscmdMzSaveModel,
  /// Clear entire world (start a new world)
  cscmdNewWorld
};

#endif // __ME_CMDS_H__
