/*  Mgraph.h

  matrix graphics functions for all floating-point data types
  for image treatment

  Copyright (c) 1996-1998 by Martin Sander
  All Rights Reserved.
*/

#ifndef __MGRAPH_H
#define __MGRAPH_H
#if !defined( __VGRAPH_H )
   #include <VGraph.h>
#endif
#if !defined( __MATLIB_H )
    #include <MatLib.h>
#endif
#ifdef __cplusplus
extern "C" {
#endif

int __vf V_findAxisRange( extended _VFAR *LoX, extended _VFAR *HiX,
                          extended xmin, extended xmax );
                          
void __vf M_findColorMapBounds( extended xmin, extended xmax,
                                extended ymin, extended ymax,
                                extended zmin, extended zmax,
                                COLORREF mincolor, COLORREF maxcolor );
void __vf M_setColorMapBounds(  extended xmin, extended xmax,
                                extended ymin, extended ymax,
                                extended zmin, extended zmax,
                                COLORREF mincolor, COLORREF maxcolor );

#define MF_xyzAutoColorMap( X, Y, MZ, ht, len, mincol, maxcol ) \
                 MFxyzAutoColorMap( X, Y, MZ[0], ht, len, mincol, maxcol )
#define MF_xyzDataColorMap( X, Y, MZ, ht, len ) \
                 MFxyzDataColorMap( X, Y, MZ[0], ht, len )
#define MF_zAutoColorMap( MZ, ht, len, mincol, maxcol ) \
                 MFzAutoColorMap( MZ[0], ht, len, mincol, maxcol )
#define MF_zDataColorMap( MZ, ht, len ) \
                 MFzDataColorMap( MZ[0], ht, len )

void __vf MFxyzAutoColorMap( fVector X, fVector Y, fPMatrix MZ,
                             unsigned ht, unsigned len,
                             COLORREF mincolor, COLORREF maxcolor );
void __vf MFxyzDataColorMap( fVector X, fVector Y, fPMatrix MZ,
                             unsigned ht, unsigned len );
void __vf MFzAutoColorMap( fPMatrix MZ, unsigned ht, unsigned len,
                             COLORREF mincolor, COLORREF maxcolor );
void __vf MFzDataColorMap( fPMatrix MZ, unsigned ht, unsigned len );

#define MD_xyzAutoColorMap( X, Y, MZ, ht, len, mincol, maxcol ) \
                 MDxyzAutoColorMap( X, Y, MZ[0], ht, len, mincol, maxcol )
#define MD_xyzDataColorMap( X, Y, MZ, ht, len ) \
                 MDxyzDataColorMap( X, Y, MZ[0], ht, len )
#define MD_zAutoColorMap( MZ, ht, len, mincol, maxcol ) \
                 MDzAutoColorMap( MZ[0], ht, len, mincol, maxcol )
#define MD_zDataColorMap( MZ, ht, len ) \
                 MDzDataColorMap( MZ[0], ht, len )

void __vf MDxyzAutoColorMap( dVector X, dVector Y, dPMatrix MZ,
                             unsigned ht, unsigned len,
                             COLORREF mincolor, COLORREF maxcolor );
void __vf MDxyzDataColorMap( dVector X, dVector Y, dPMatrix MZ,
                             unsigned ht, unsigned len );
void __vf MDzAutoColorMap( dPMatrix MZ, unsigned ht, unsigned len,
                             COLORREF mincolor, COLORREF maxcolor );
void __vf MDzDataColorMap( dPMatrix MZ, unsigned ht, unsigned len );

#define ME_xyzAutoColorMap( X, Y, MZ, ht, len, mincol, maxcol ) \
                 MExyzAutoColorMap( X, Y, MZ[0], ht, len, mincol, maxcol )
#define ME_xyzDataColorMap( X, Y, MZ, ht, len ) \
                 MExyzDataColorMap( X, Y, MZ[0], ht, len )
#define ME_zAutoColorMap( MZ, ht, len, mincol, maxcol ) \
                 MEzAutoColorMap( MZ[0], ht, len, mincol, maxcol )
#define ME_zDataColorMap( MZ, ht, len ) \
                 MEzDataColorMap( MZ[0], ht, len )

void __vf MExyzAutoColorMap( eVector X, eVector Y, ePMatrix MZ,
                             unsigned ht, unsigned len,
                             COLORREF mincolor, COLORREF maxcolor );
void __vf MExyzDataColorMap( eVector X, eVector Y, ePMatrix MZ,
                             unsigned ht, unsigned len );
void __vf MEzAutoColorMap( ePMatrix MZ, unsigned ht, unsigned len,
                             COLORREF mincolor, COLORREF maxcolor );
void __vf MEzDataColorMap( ePMatrix MZ, unsigned ht, unsigned len );

#ifdef __cplusplus
}
#endif
#endif /* __MGRAPH_H */
