/*  VQImath.h

  vector management functions for data type "quad":
  integer arithmetics and mathematics.

  Copyright (c) 1996-1998 by Martin Sander
  All Rights Reserved.
*/

#ifndef __VQIMATH_H
#define __VQIMATH_H

#if !defined( __VECLIB_H )
   #include <VecLib.h>
#endif


#ifdef __cplusplus
   extern "C" {
#endif

/******************   Basic  Arithmetics   *************************/

void    __vf  VQI_neg( qiVector Y, qiVector X, ui size );
void    __vf  VQI_abs( qiVector Y, qiVector X, ui size );

void    __vf  VQI_addC(  qiVector Y, qiVector X, ui size, quad C );
void    __vf  VQI_subC(  qiVector Y, qiVector X, ui size, quad C );
void    __vf  VQI_subrC( qiVector Y, qiVector X, ui size, quad C );
void    __vf  VQI_mulC(  qiVector Y, qiVector X, ui size, quad C );
void    __vf  VQI_divC(  qiVector Y, qiVector X, ui size, quad C );
void    __vf  VQI_divrC( qiVector Y, qiVector X, ui size, quad C );
void    __vf  VQI_modC(  qiVector Y, qiVector X, ui size, quad C );
void    __vf  VQI_maxC(  qiVector Y, qiVector X, ui size, quad C );
void    __vf  VQI_minC(  qiVector Y, qiVector X, ui size, quad C );

void    __vf  VQI_addV(  qiVector Z, qiVector X, qiVector Y, ui size );
void    __vf  VQI_subV(  qiVector Z, qiVector X, qiVector Y, ui size );
void    __vf  VQI_subrV( qiVector Z, qiVector X, qiVector Y, ui size );
void    __vf  VQI_mulV(  qiVector Z, qiVector X, qiVector Y, ui size );
void    __vf  VQI_divV(  qiVector Z, qiVector X, qiVector Y, ui size );
void    __vf  VQI_divrV( qiVector Z, qiVector X, qiVector Y, ui size );
void    __vf  VQI_modV(  qiVector Z, qiVector X, qiVector Y, ui size );
void    __vf  VQI_maxV(  qiVector Z, qiVector X, qiVector Y, ui size );
void    __vf  VQI_minV(  qiVector Z, qiVector X, qiVector Y, ui size );

/*****************   Bit-wise operations  *********************/

void    __vf  VQI_shl( qiVector Y, qiVector X, ui size, unsigned C );
void    __vf  VQI_shr( qiVector Y, qiVector X, ui size, unsigned C );

void    __vf  VQI_and( qiVector Y, qiVector X, ui size, quad C );
void    __vf  VQI_or(  qiVector Y, qiVector X, ui size, quad C );
void    __vf  VQI_xor( qiVector Y, qiVector X, ui size, quad C );
void    __vf  VQI_not( qiVector Y, qiVector X, ui size );

#ifdef __cplusplus
}
#endif

#endif   /*  __VQIMATH_H    */