/* ------------------------------------------------------------------ */
/* CMD to create (or update) the object for REXX Tips & Tricks        */
/*                                                                    */
/* The default is on the desktop, but if you have already an object   */
/* for an older version of RXT&T this program will update that        */
/* object.                                                            */
/*                                                                    */
/* Usage: INSTALL {os2BootDrive}                                      */
/*                                                                    */
/* Default: Search the OS/2 boot drive                                */
/*                                                                    */
/*                                                                    */
/* Last update: 26.12.1995 /bs                                        */
/*                                                                    */
/*                                                                    */
/* ------------------------------------------------------------------ */

                        /* check & process the parameter              */
  parse arg OS2BootDrive
  OS2BootDrive = substr( translate( strip( OS2BootDrive ) ),1,2 )
  if OS2BootDrive <> '' then
    if stream( OS2BootDrive || '\CONFIG.SYS', 'c', 'QUERY EXIST' ) = '' then
    do
                        /* show the usage                             */
      say 'Usage: INSTALL {os2BootDrive}'
      say ''
      say 'Default: Search the OS/2 boot drive'
      exit 253
    end /* if stream( ... */
  
                        /* init the return code                       */
  thisRC = 255

                        /* init some global variables                 */
  fileMask =          'RXTT*.INF'
  fixedName =         'RXTT'
  defaultTitle =      'REXX Tips & Tricks'
  curObjectID =       '<RXTT>'
  defaultLocation =   '<WP_DESKTOP>'

                        /* show the logo                              */
  say ''
  say center( 'Installation program for REXX Tips & Tricks', 79 )
  say center( '===========================================', 79 )
  say ''

                        /* install some error handler                 */
  signal on halt name UserAbort
  signal on syntax name RexxUtilNotFound

  say ' Loading REXXUTIL ... '
  
                        /* load REXXUTIL                              */
  call rxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
  call SysLoadFuncs

                        /* turn on the default error handler again    */
  signal off Syntax

                        /* search the OS/2 boot drive                 */
  if OS2BootDrive = '' then
  do
    say ' Searching the boot drive. Please wait ...'
    OS2BootDrive = SearchbootDrive()

    say ' ... Bootdrive "' || OS2BootDrive || '" found.'
  end /* if OS2BootDrive = '' then */


  say ' Searching the newest version of ' || defaultTitle || ' ...'

                        /* search RXTT*.INF                           */
  call SysFileTree fileMask, 'infFileStem' , 'FO'

                        /* get the newest version                     */
  curInfFileVersion = '00'
 
  do i = 1 to infFileStem.0
    parse upper var infFileStem.i (fixedName) infFileVersion '.' .
    if infFileVersion > curInfFileVersion then
    do
      curInfFile = infFileStem.i
      curInfFileVersion = infFileVersion
    end /* infFileVersion > curInfFileVersion then */
  end /* do i = 1 to infFileStem.0 */

                        /* check, if we found a version of RXT&T      */  
  if curInfFileVersion <> '00' then
  do
    curtitle = strip( getTitle( '"' || curInfFile || '"' ) )
    curTitle = translate( curTitle, '^', ',' )

    say ' ... version "' || curTitle || '" found.'
    say ''
    say ' Should I create an object for "' || curTitle || '" (Y/n)? '
    userResponse = substr( strip( translate( SysGetKey( 'NOECHO' ) ) ),1,1 )
    if UserResponse = 'N' then 
      signal UserAbort

    say ' Creating the object ...'

                        /* create the object                          */
    tempRC = SysCreateObject( 'WPProgram' ,,
                              curTitle ,,
                              defaultLocation ,,
                             'EXENAME=' || OS2BootDrive || '\OS2\VIEW.EXE;' || ,
                             'PARAMETERS="' || curInfFile || '";' || ,
                             'STARTUPDIR=' || OS2BootDrive || '\;' || ,
                             'TITLE=' || curTitle || ';' || ,
                             'OBJECTID=' || curObjectID || ';' ,,
                             'U' )

    if tempRC = 1 then
    do
      thisRC = 0
      say ' ... object created.'
    end /* if tempRC = 1 then */
    else
      say 'Error creating the object!'

  end /* if curInfFileVersion <> '00' then */
  else
    say 'Error: ' || defaultTitle || ' not found!'

exit thisRC

/* ------------------------------------------------------------------ */
/* function:   search the boot drive                                  */
/*                                                                    */
/* parameters: none                                                   */
/*                                                                    */
/* returns:    boot drive (e.g. "C:")                                 */
/*                                                                    */
SearchBootDrive: PROCEDURE 

                        /* install a local error handler              */
  signal on syntax name BootDriveNotFound

                    /* try the new function from the new REXXUTIL DLL */
  OS2BootDrive = SysBootDrive()

BootDriveNotFound:

  if symbol( 'OS2BootDrive' ) <> 'VAR' then
  do
                        /* new REXXUTIL DLL not found  --             */
                        /* use the old method                         */
    OS2BootDrive = substr( value( 'RUNWORKPLACE' ,, 'OS2ENVIRONMENT' ), 1,2 )

    if OS2BootDrive = '' then
      OS2BootDrive = substr( value( 'COMSPEC' ,, 'OS2ENVIRONMENT' ), 1,2 )

    if OS2BootDrive = '' then
      OS2BootDrive = 'C:'

  end /* if symbol( 'OS2BootDrive' ) <> 'VAR' then */  
RETURN OS2BootDrive

/* ------------------------------------------------------------------ */
/* function:   get the title of an INF file                           */
/*                                                                    */
/* parameters: fully qualified path of the INF file                   */
/*                                                                    */
/* returns:    the title of the INF file                              */
/*                                                                    */
GetTitle: PROCEDURE
  parse arg '"' infFile '"'

                        /* init the return code                       */
  thisTitle = ''
         
                        /* read the header of the INF file            */
  thisRC = stream( infFile'"', 'c', 'OPEN READ' )
  infHeader = charIn( infFile, 1,500 )
  thisRC = stream( infFile, 'c', 'CLOSE' )

                        /* search the title                           */
  startPos = x2d( '6B' )

  do i = 1 to 100
    curChar = substr( infHeader, startPos+i, 1 )
    if curChar = '00'x then
      leave
    else
     thisTitle = thisTitle || curChar
  end /* do i=0 to 100 */

RETURN thisTitle 

/* ------------------------------------------------------------------ */
/* Error handler (called if the DLL REXXUTIL is not found)            */
/*                                                                    */
RexxUtilNotFound:
  say ''
  say 'Error: REXXUTIL.DLL not found!'
exit 255

/* ------------------------------------------------------------------ */
/* Error handler (called if the user presses CTRL-BREAK)              */
/*                                                                    */
UserAbort:
  say ''
  say ' Installation aborted by the user.'
exit 254
