/*
** Rexx Program
*/
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

PARSE VALUE ARG(1) WITH StartHours ':' StartMins ':' StartSecs ' ' EndHours ':' EndMins ':' EndSecs ' '

if StartHours = '' | StartMins = '' | StartSecs = '' | ,
   EndHours = '' | EndMins = '' | EndSecs = '' then do
   say 'USAGE: DIFFTIME hh:mm:ss hh:mm:ss'
   return
end


StartTotal = ( StartHours * 3600 ) + ( StartMins * 60 ) + StartSecs
EndTotal   = ( EndHours * 3600   ) + ( EndMins * 60 )   + EndSecs
DiffTotal = EndTotal - StartTotal

EndHours = DiffTotal % 3600
DiffTotal = DiffTotal - ( EndHours * 3600 )
EndMins  = DiffTotal % 60
EndSecs  = DiffTotal - ( EndMins * 60 )

Say 'Duration: ' EndHours 'hrs. ' EndMins 'mins.' EndSecs 'secs.'

