(*  JAM Application Programming Interface for Virtual Pascal/2, Version 1.2  *)
(*    Copyright (C) 1996-1997 Dusk To Dawn Computing. All Rights Reserved.   *)
(*                             Sample Application                            *)
(* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- *)
(* History:                                                                  *)
(*                                                                           *)
(* 07 Jun 1996 1.00  Initial coding                                          *)
(* 12 Mar 1997 1.01  Conversion to use 0.91 object                           *)
(* 14 Jun 1997 1.02  Conversion to use 1.11 object                           *)
(* 14 Jun 1997 1.03  Conversion to use 1.22 object                           *)

program JamUtilP;

{$D $@#Dusk To Dawn Computing, Inc.:1.03 (16 Jun 1997)#@VPJAM Utility/Demo program }

uses
   Crt,
   JAM,
   JAMMB,
   JAMINFO,
   SysUtils,
   UnixTime,
   Use32;

const
   Version     = '1.03';

var
   Done:       Boolean;
   FName:      tFileName;
   MsgBase:    tJamBase;
   MsgNum:     LongInt;
   TempChr:    Char;
   TempStr:    String;

procedure Usage(Level: LongInt);

begin
   case Level of
      1:
      begin
         WriteLn('     JAMutil: A program to test VPJAM functions, Version ', Version);
         WriteLn('Copyright (C) 1996-1997 Dusk To Dawn Computing. All Rights Reserved.');
      end;
      2:
      begin
         Usage(1);
         WriteLn('Usage: ' + ParamStr(0) + ' <MsgBase> [MsgNum]');
         WriteLn('Where:  <MsgBase> is the path and base filename of the JAM Message Base');
         WriteLn('        <MsgNum>  is the first message number to display.');
      end;
   end;
end;

begin
   try
      ClrScr;
      if ((ParamCount < 1) or (ParamCount > 2)) then
      begin
         Usage(2);
         Halt(1);
      end
      else
         Usage(1);
      if ParamCount >= 2 then
         MsgNum := StrToIntDef(ParamStr(2), 1)
      else
         MsgNum := 0;
      MsgBase := tJamBase.Create(65536);
      MsgBase.BaseName := ParamStr(1);
      try
         MsgBase.Open := True;
      except
         WriteLn(Format('Unable to open message base "%s".', [MsgBase.BaseName]));
         Halt(1);
      end;
      if MsgNum = 0 then
         MsgNum := MsgBase.HdrInfo.BaseMsgNum;
      DisplayMsgHdr(MsgBase, MsgNum);
      while not Done do
      begin
         Write(#13#10, 'H=HdrInfo, N=Next, P=Prev, Q=Quit, R=ReIndex, S=SubFields, T=Text: ');
         TempChr := UpCase(ReadKey);
         case TempChr of
         'Q', #27:
            begin
               Write('Quit');
               Done := True;
               Break;
            end;
         'H':
            begin
               Write('HdrInfo');
               ClrScr;
               Usage(1);
               DisplayHdrInfo(MsgBase);
            end;
         'N':
            begin
               Write('Next');
               Inc(MsgNum);
               ClrScr;
               Usage(1);
               DisplayMsgHdr(MsgBase, MsgNum);
            end;
         'P':
            begin
               Write('Prev');
               Dec(MsgNum);
               ClrScr;
               Usage(1);
               DisplayMsgHdr(MsgBase, MsgNum);
            end;
         'R':
            begin
               Write('ReIndex');
               MsgBase.Locked := True;
               try
                  ClrScr;
                  Usage(1);
                  WriteLn;
                  Write('ReIndexing...');
                  MsgBase.ReIndex;
                  WriteLn('Done.');
               except
                  WriteLn('Failed. Message base has likely been destroyed.');
               end;
               MsgBase.Locked := False;
            end;
         'S':
            begin
               Write('SubFields');
               ClrScr;
               Usage(1);
               DisplayMsgSubFld(MsgBase);
            end;
         'T':
            begin
               Write('Text');
               ClrScr;
               Usage(1);
               DisplayMsgTxt(MsgBase);
            end;
         '0'..'9':
            begin
               TempStr := '';
               Write('Goto msg #', TempChr);
               Readln(TempStr);
               Insert(TempChr, TempStr, 1);
               MsgNum := StrToIntDef(TempStr, 1);
               ClrScr;
               Usage(1);
               DisplayMsgHdr(MsgBase, MsgNum);
            end;
         else
            Continue;
         end;
      end;
      Halt(0);
   except
      on E: Exception do
      begin
         WriteLn;
         WriteLn('Exception caught, exiting. Exception message: ', E.Message);
         MsgBase.Free;
         Halt(1);
      end;
   end;
end.
