UNIT EditU1;

{ SpeedSoft Sibyl Sample application
  (C) 1996 SpeedSoft, All rights reserved.

  This application implements a simple text editor using the visual environment
  of SpeedSoft Sibyl.

  The application includes three form. This MainForm (EditorApp) includes a menubar and
  a toolbar to select actions on the current edit window.
  This example also demonstrates the use of the SPCC standard dialogs.
}

INTERFACE

USES Classes,Forms,StdCtrls,Editors,StdDlgs,Buttons;

{Menu constants}
CONST
     cmEditorOptions=cmUser+1;

TYPE
    TToolBar1=Class(TToolBar)
         SpeedButton1:TSpeedButton;
         SpeedButton2:TSpeedButton;
         SpeedButton3:TSpeedButton;
         SpeedButton4:TSpeedButton;
         SpeedButton5:TSpeedButton;
         SpeedButton6:TSpeedButton;
         SpeedButton7:TSpeedButton;
    End;

    TEditorApp=CLASS(TForm)
         ToolBar1:TToolBar1;
         FileOpenDialog1:TFileOpenDialog;
         PROCEDURE EditorAppOnCommandEvent(Sender:TComponent;VAR Msg:TMessage;Command:TCommand);
         PROCEDURE LoadEditor;
         PROCEDURE NewEditor;
    END;

VAR
    EditorApp:TEditorApp;

Type
    TAboutDlg=Class(TForm)
         StaticText1:TStaticText;
         StaticText2:TStaticText;
         StaticText3:TStaticText;
         GroupBox1:TGroupBox;
         BitButton1:TBitButton;
    End;

Var
    AboutDlg:TAboutDlg;

Type
    TEditorPage=Class(TNoteBookPage)
         CheckBox1:TCheckBox;
         CheckBox2:TCheckBox;
         CheckBox3:TCheckBox;
         CheckBox4:TCheckBox;
         CheckBox5:TCheckBox;
         CheckBox6:TCheckBox;
         CheckBox7:TCheckBox;
         CheckBox8:TCheckBox;
         CheckBox9:TCheckBox;
         GroupBox1:TGroupBox;
         GroupBox2:TGroupBox;
         GroupBox3:TGroupBox;
         StaticText1:TStaticText;
         EntryField1:TEntryField;
         StaticText2:TStaticText;
         EntryField2:TEntryField;
         CheckBox10:TCheckBox;
         EntryField3:TEntryField;
         RadioButton1:TRadioButton;
         RadioButton2:TRadioButton;
    End;

    TColorsPage=Class(TNoteBookPage)
    End;

    TNoteBook1=Class(TNoteBook)
         EditorPage:TEditorPage;
         ColorsPage:TColorsPage;
    End;

    TEditorOptDlg=Class(TForm)
         NoteBook1:TNoteBook1;
         Procedure EditorOptDlgOnSetupShow(Sender:TComponent);
         Procedure EditorOptDlgOnDismissDlg(Sender:TComponent);
    End;

    TSampleEditor=Class(TEditor)
         Procedure SetupComponent;Override;
         Procedure SetupEditor;
    End;

{Editor option masks}
Const
    EDITOPT_INSERTMODE  = 1 SHL 0;
    EDITOPT_AUTOINDENT  = 1 SHL 1;
    EDITOPT_UNINDENT    = 1 SHL 2;
    EDITOPT_CURSORLEFT  = 1 SHL 3;
    EDITOPT_BLOCKSEL    = 1 SHL 4;
    EDITOPT_2CLICKLINE  = 1 SHL 5;
    EDITOPT_PERSISTENT  = 1 SHL 6;
    EDITOPT_OVERWRITE   = 1 SHL 7;
    EDITOPT_UNDOGROUPS  = 1 SHL 8;
    EDITOPT_WORDWRAP    = 1 SHL 9;

    EDITMODE_CUA        = 1;
    EDITMODE_WORDSTAR   = 0;

Var
    EditorOptDlg:TEditorOptDlg;

Const
    EditorOpt:LongInt=EDITOPT_AUTOINDENT OR EDITOPT_UNINDENT OR
                      EDITOPT_UNDOGROUPS OR EDITOPT_CURSORLEFT OR
                      EDITOPT_2CLICKLINE OR EDITOPT_PERSISTENT OR
                      EDITOPT_WORDWRAP OR EDITOPT_INSERTMODE;
    EditorMode:Boolean=FALSE; {Wordstar}
    EditorTabSize:Longint=8;
    EditorMaxUndo:Longint=128;
    EditorWrapColumn:Longint=80;

IMPLEMENTATION


Procedure TSampleEditor.SetupEditor;
Var  Opt:TEditOpt;
Begin
     Opt := [];
     IF EditorOpt AND EDITOPT_AUTOINDENT <> 0 THEN Opt := Opt + [eoAutoIndent];
     IF EditorOpt AND EDITOPT_UNINDENT <> 0 THEN Opt := Opt + [eoUnindent];
     IF EditorOpt AND EDITOPT_UNDOGROUPS <> 0 THEN Opt := Opt + [eoUndoGroups];
     IF EditorOpt AND EDITOPT_CURSORLEFT <> 0 THEN Opt := Opt + [eoCursorClimb];
     IF EditorOpt AND EDITOPT_BLOCKSEL <> 0 THEN Opt := Opt + [eoExtSelection];
     IF EditorOpt AND EDITOPT_2CLICKLINE <> 0 THEN Opt := Opt + [eo2ClickLine];
     IF EditorOpt AND EDITOPT_PERSISTENT <> 0 THEN Opt := Opt + [eoPersistentBlocks];
     IF EditorOpt AND EDITOPT_OVERWRITE <> 0 THEN Opt := Opt + [eoOverwriteBlock];
     IF EditorOpt AND EDITOPT_WORDWRAP <> 0 THEN Opt := Opt + [eoWordWrap];
     EditOptions := Opt;

     IF InputMode <> imReadOnly THEN
     BEGIN
          IF EditorOpt AND EDITOPT_INSERTMODE <> 0
          THEN InputMode := imInsert
          ELSE InputMode := imOverwrite;
     END;

     IF EditorMode THEN
     BEGIN
          IF EditMode <> emCUA THEN EditMode := emCUA;
     END
     ELSE
     BEGIN
          IF EditMode <> emWordStar THEN EditMode := emWordStar;
     END;

     TabSize := EditorTabSize;
     MaxUndoEvents := EditorMaxUndo;
     WordWrapColumn := EditorWrapColumn;
     InvalidateEditorWindow(0,0);
End;

Procedure TSampleEditor.SetupComponent;
Begin
     Inherited SetupComponent;
     SetupEditor;
End;

Procedure TEditorOptDlg.EditorOptDlgOnSetupShow(Sender:TComponent);
Begin
     With NoteBook1.EditorPage Do
     Begin
          SetPackedCheckBoxList([CheckBox1,CheckBox2,CheckBox3,CheckBox4,CheckBox5,CheckBox6,
                                 CheckBox7,CheckBox8,CheckBox9,CheckBox10],EditorOpt);

          IF EditorMode THEN RadioButton1.IsChecked := TRUE
          ELSE RadioButton2.IsChecked := TRUE;
          EntryField1.Caption := tostr(EditorTabSize);
          EntryField2.Caption := tostr(EditorMaxUndo);
          EntryField3.Caption := tostr(EditorWrapColumn);
     End;
End;

Procedure TEditorOptDlg.EditorOptDlgOnDismissDlg(Sender:TComponent);
Var Wert:Longint;
    c:Integer;
 Procedure UpdateEditor(Editor:TForm);
 Begin
      TSampleEditor(Editor).SetupEditor;
 End;

Begin
     With NoteBook1.EditorPage Do
     Begin
          EditorOpt := GetPackedCheckBoxList([CheckBox1,CheckBox2,CheckBox3,
                                              CheckBox4,CheckBox5,CheckBox6,
                                              CheckBox7,CheckBox8,CheckBox9,
                                              CheckBox10]);
          EditorMode := RadioButton1.IsChecked;

          val(EntryField1.Caption,wert,c);
          IF c = 0 THEN EditorTabSize := wert;
          val(EntryField2.Caption,wert,c);
          IF c = 0 THEN EditorMaxUndo := wert;
          val(EntryField3.Caption,wert,c);
          IF c = 0 THEN EditorWrapColumn := wert;
     End;
     {Update all editor windows with new settings}
     EditorApp.ForEachMDI(UpdateEditor);
End;

PROCEDURE TEditorApp.LoadEditor;
VAR
    s:STRING;
    Ed:TSampleEditor;
BEGIN
     FileOpenDialog1.AddFileType('*.TXT','Text files');
     FileOpenDialog1.WildCards := '*.TXT';
     s := FileOpenDialog1.Run;
     IF s <> '' THEN
     BEGIN
          Ed := InsertMDIChild(TSampleEditor);
          IF Ed <> NIL THEN
          BEGIN
               Ed.LoadFile(s);
               Ed.Show;
          END;
     END;
END;

PROCEDURE TEditorApp.NewEditor;
VAR Ed:TSampleEditor;
BEGIN
     Ed:=InsertMDIChild(TSampleEditor);
     Ed.Caption:='Untitled';
END;

PROCEDURE TEditorApp.EditorAppOnCommandEvent(Sender:TComponent;VAR Msg:TMessage;Command:TCommand);
Var Editor:TSampleEditor;
BEGIN
     Editor := Application.MainForm.ActiveMDIChild;

     CASE command OF
        {File Menu}
        cmNew:NewEditor;
        cmOpen:LoadEditor;
        {Edit Menu}
        cmUndo:IF Editor <> NIL THEN Editor.cmUndo;
        cmRedo:IF Editor <> NIL THEN Editor.cmRedo;
        cmCut:IF Editor <> NIL THEN Editor.cmCutToClipBoard;
        cmCopy:IF Editor <> NIL THEN Editor.cmCopyToClipBoard;
        cmPaste:IF Editor <> NIL THEN Editor.cmPasteFromClipBoard;
        cmDelete:IF Editor <> NIL THEN Editor.DeleteSelection;
        cmSelectAll:IF Editor <> NIL THEN Editor.SelectAll;
        cmDeselectAll:IF Editor <> NIL THEN Editor.DeselectAll;
        {Search Menu}
        cmFind:IF Editor <> NIL THEN Editor.cmFindText;
        cmReplace:IF Editor <> NIL THEN Editor.cmReplaceText;
        cmSearchAgain:IF Editor <> NIL THEN Editor.cmSearchTextAgain;
        {Help Menu}
        cmAbout:
        Begin
             AboutDlg.Create(Self);
             AboutDlg.ShowModal;
             AboutDlg.Destroy;
        End;
        cmEditorOptions:
        Begin
             EditorOptDlg.Create(Self);
             EditorOptDlg.ShowModal;
             EditorOptDlg.Destroy;
        End;
     END; {case}
END;

BEGIN
     RegisterComponents([TEditorApp,TToolBar1,TFileOpenDialog,
                         TSpeedButton,TFindTextDialog,
                         TReplaceTextDialog,TCheckBox,TAboutDlg,
                         TStaticText,TGroupBox,TBitButton,TEditorOptDlg,
                         TNoteBook1,TEditorPage,TColorsPage,
                         TEntryField,TRadioButton]);
END.
