UNIT SimpU1;

{ SpeedSoft Sibyl Sample application
  (C) 1996 SpeedSoft, All rights reserved.

  This application demonstrates how to handle command messages using the visual environment
  of SpeedSoft Sibyl.

  The application includes one form. This MainForm (SimpleApp) includes a bitbutton control.
  If you click onto the button the color of the background will change.
  The button is center aligned within the form in both X and Y directions.
}

INTERFACE

USES Classes,Forms,StdCtrls,Buttons;

//The default RGB color values of the SPCC library
TYPE
    TColorArray=RECORD
                  Value:TColor;
                  ValueName:STRING[10];
                END;

CONST
     Colors:ARRAY[0..17] OF TColorArray=
       (
        (Value:clBlack;ValueName:'clBlack'),
        (Value:clMaroon;ValueName:'clMaroon'),
        (Value:clGreen;ValueName:'clGreen'),
        (Value:clOlive;ValueName:'clOlive'),
        (Value:clNavy;ValueName:'clNavy'),
        (Value:clPurple;ValueName:'clPurple'),
        (Value:clTeal;ValueName:'clTeal'),
        (Value:clGray;ValueName:'clGray'),
        (Value:clSilver;ValueName:'clSilver'),
        (Value:clRed;ValueName:'clRed'),
        (Value:clLime;ValueName:'clLime'),
        (Value:clYellow;ValueName:'clYellow'),
        (Value:clBlue;ValueName:'clBlue'),
        (Value:clFuchsia;ValueName:'clFuchsia'),
        (Value:clAqua;ValueName:'clAqua'),
        (Value:clLtGray;ValueName:'clLtGray'),
        (Value:clDkGray;ValueName:'clDkGray'),
        (Value:clWhite;ValueName:'clWhite')
       );


TYPE
    TSimpleApp=CLASS(TForm)
         BitButton1:TBitButton;
         //a variable holding the currently active color index
         ActiveColor:BYTE;
         PROCEDURE SimpleAppOnCommandEvent(Sender:TComponent;VAR Msg:TMessage;Command:TCommand);
    END;

VAR
    SimpleApp:TSimpleApp;

IMPLEMENTATION

//this event handler handles command events. If you press the button a command event
//will be posted to the form with the Command value set to cmOk. This is the value
//provided within the "SendCommand" property of the button. Since we only have one
//button we do not need to test the Command value here.
PROCEDURE TSimpleApp.SimpleAppOnCommandEvent(Sender:TComponent;VAR Msg:TMessage;Command:TCommand);
BEGIN
     inc(ActiveColor);
     IF ActiveColor>17 THEN ActiveColor:=0;
     //set the backcolor of the form
     WinBackColor:=Colors[ActiveColor].Value;
     //change the caption of the form window
     Caption:='The color is now set to '+Colors[ActiveColor].ValueName;
END;

BEGIN
     RegisterComponents([TSimpleApp,TBitButton]);
END.
