unit Seven;

{SpeedSoft Sibyl Sample component.
 Install this component using Component|Install.

 This component was written by Joerg Pleumann
}

interface

{$r Seven}

uses
  Classes, StdCtrls, Graphics;

type
  TSevenSegDisplay = class(TOwnerDrawButton)
  private
    FDigit: Byte;
    FBitmaps: array[0..9] of TBitmap;

    procedure SetDigit(NewDigit: Byte);

  public
    destructor Destroy; override;

    procedure Redraw(const rec: TRect); override;
    procedure SetupComponent; override;
    procedure Show; override;

  published

    property Digit: Byte read FDigit write SetDigit;
  end;

exports
  TSevenSegDisplay, 'User', 'Seven.Bmp';

implementation

destructor TSevenSegDisplay.Destroy;
var
  N: Integer;
begin
  for N := 0 to 9 do FBitmaps[N].Free;
  inherited Destroy;
end;

procedure TSevenSegDisplay.SetDigit(NewDigit: Byte);
begin
  if (NewDigit >= 0) and (NewDigit <= 9) then
  begin
    FDigit := NewDigit;
    InvalidateWindow;
  end;
end;

procedure TSevenSegDisplay.SetupComponent;
var
  N: Integer;
begin
  inherited SetupComponent;

  Caption := 'SevenSegDisplay';
  Name := Caption;
  Width := 16;
  Height := 24;

  for N := 0 to 9 do
  begin
    FBitmaps[N].Create(Self);
    FBitmaps[N].LoadFromRes(7000 + N);
  end;
end;

procedure TSevenSegDisplay.Show;
begin
  FBitmaps[FDigit].RealizePalette(Canvas);
  inherited Show;
end;

procedure TSevenSegDisplay.Redraw(const rec: TRect);
begin
  if (FDigit >= 0) and (FDigit <= 9) then
    Canvas.DrawStretchedGraphic(0, 0, Width, Height, FBitmaps[FDigit]);
end;

begin
  RegisterComponents([TSevenSegDisplay]);
end.
