#include "client.h"

int setupSockets(VOID) {
/* This function calls sock_init() to initialize the app for sockets and then creates
   the socket for this app. Reutrns the descriptor of the socket is all goes well
   otherwise it returns 0 or the socket errno meaning something is wrong */

   int rc;  /* Return code for sock_init() */
   int tempSocket;  /*local variable for the socket */

   /* Lets call sock_init() and see if INET.SYS is running or not */
   rc = sock_init();

   if (rc == 0) {
      /* We are successful. Lets call socket() and create our socket */
      tempSocket = socket(AF_INET,       /*Internet domain family - See part 1 */
                          SOCK_STREAM,   /*Stream socket type - See part 1 */
                          0);            /* Protocol requested */

      if (tempSocket > -1) {
         /* Success again! Any non-negative return indicates success and teh returned
            value is the socekt descriptor*/
         return tempSocket;
         } else {
            /* If the socket creation failed we will return the socket error code
               the negative of the errno is being returned since a positive return
               would be seen as a socket descriptor in this program */
            return (-1 * sock_errno());
         }
   } else {
      return 0;
   }
}

VOID connectToServer(int Socket,char *servername, int port) {
/* Here we connect to our server on success we post the SM_CONNECTED message */

   struct sockaddr_in server;          /* This struct is covered in part 1*/
   struct hostent *hostname;                 /* Will hold inet address of hostname */
   int rc;                                  /* generic return code variable */
   BOOL login;


   memset(&server, 0, sizeof(server));  /*initialize the structure */

   /*lets get the internet address of the host first */
   hostname = gethostbyname(servername);
   if (hostname != (struct hostent*) NULL) {
      /* We should have our internet address */
      server.sin_family = AF_INET;         /* Internet domain family */
      server.sin_addr.s_addr = *((unsigned long *)hostname->h_addr);
      server.sin_port = htons(port);

      /* actually connect now */
      if (connect(Socket, (struct sockaddr *) &server, sizeof(server)) == 0) {
         /* Send a login packet to the server to let them know who we are */
         if (loginToServer(Socket, cData->nick)) {
            /* We successfully connected. Send teh SM_CONNECTED message */
            WinPostMsg(hwndClient, SM_CONNECTED, 0, 0);
         } else {
            WinPostMsg(WinWindowFromID(hwndClient, WND_OUTPUT), MLM_INSERT, "Unable to Connect", 0);
         } /* End If Login */

      } else {
         /* We canget teh socket error here if we want */
         WinPostMsg(WinWindowFromID(hwndClient, WND_OUTPUT), MLM_INSERT, "Unable to Connect", 0);

      } /* Edn if Connect */

   } else {
      /* we can get the error message here if we want */
   }

}

BOOL loginToServer(int socket, char *nickname) {
/* Here we weill send the login packet to the server and wait for its reply */
/* Once this is done we will return TRUE (if successful) and the send - receive*/
/* threads will be created */
/* The login packet has this format:
   aLoginid^ANickname^ADefaultGroup^ACommand
   Where the fields are separated by the ^A's and are the following:
     * Packet Type: 'a' (Login)
     * Fields: Minimum: 5, Maximum: 7
          + Field 0: Login id of user. Required. We will use EDMIReader
          + Field 1: Nickname to use upon login into ICB. Required.Your Pick
          + Field 2: Default group to log into in ICB. Required. We are going to EDMRead
          + Field 3: Login command. Required. Currently one of the
            following:
               o "login" log into ICB
          + Field 4: Password: Can be blank..Use later
       This looks like alot of junk..It is..I am connecting to  a IRC LIKE server
     until I finish my server code. This is a place were people hang out so please
      be courteous or I will not be allowed to use the server anymore....*/

   int  packetsize;           /* The size of the packet MUST be the first byte of dat sent to the server */
   char *packet;
   char *rcvbuffer;
   int  trnslen;             /* Bytes sent in send call */
   int  recvlen;             /* Byte recved in recv call*/
   char pktlen[1];
   int  pktremain;
   char *pktptr;              /* This will point to thenext space in our buffer for recving*/
   int  sockerr;
   char freeptr;              /* THis will point to the original rcvbuffer so we can free that mem */
   int  bytesent;

   /*Lets create our packet now */
   packet = malloc(255);          /*This is the maximum packet size we can have*/

   /* this is our login packet..the first character is ablank becasue we will be putting hte string size in there */
   packetsize = sprintf(packet, " a%s\001%s\001%s\001%s\001%s","os2clnt", nickname, "WICB","login","\0" );

   /* Now append the packetlength and include the length byte in that count */
   packet[0] = (unsigned char) (strlen(packet));  /* Add one for the extra byte */

   /*Lets get the total packet size now..This is for our send command*/
   packetsize = (int)packet[0];

   /* Ok our server will send a login packet to use first.This will tell us the protocol
      We are on. For this server is doesn't matter but we still need to scarf this packet */
   /* The protocol packet is headed by a 'j' character and has this form:
               jProtoLevel - where protolevel is the protocol number..*/

   if ((recvlen = recv(socket, &pktlen, 1, 0)) > 0) {
      /* We got data */
      pktremain = (int)pktlen[0] - 1;           /*Set this int to our packet len*/
      rcvbuffer = malloc(pktremain + 1);
      /*Lets make sure there is a null terminator at the end of the recieved packet */
      rcvbuffer[pktremain+1] = '\0';

      /* Now get the whole packet. Add one to grab the null terminator that should come through */
      if ((recvlen = recv(socket, rcvbuffer, pktremain+1, 0)) < 0) {
         /* We have a problem lets get the error here */
      } else {
         /* We got the whole packet */
         pktptr = rcvbuffer;

      } /*End if - Packet recv() was successful */

      /* advance read pointer */
      pktptr += recvlen;

      /* see if we read the whole thing */
      if (((pktremain -= recvlen) +1) == 0) {
          /* We got it..Now lets check to make sure we got a j code - and send our login */
          if (rcvbuffer[0] == 'j') {
              /*Declare two pointers to hold the strings from the packet */
              char *hostid;
              char *serverid;
              char *locator;
              char outBuffer[1024];

              /* Advance to the protocol number */
              locator = rcvbuffer;
              locator++;
              /* Advance to the  Host ID. This should be icb.sjsu.edu */
              locator += 2;  /* Remember that a ^A splits fields. We want to skip 1 beyon that */
              hostid = locator;
              /* Find the field split*/
              locator = strchr(hostid, '\001');
              serverid = ++locator;
              locator--;
              *locator = '\0';

              /* Now we will display this info to the output window */
              sprintf(outBuffer, "You are connected to the %s at %s\n", serverid, hostid);
              WinPostMsg(WinWindowFromID(hwndClient, WND_OUTPUT), MLM_INSERT, MPFROMP(outBuffer), 0);

              /* Now send the login packet. We add +1 to send the \0 terminator with the packet */
              if ((bytesent = send(socket, packet, packet[0]+1, 0)) >0 ) {
                 /* We gotta good send */
                 /*Lets free that rcvbuffer and packet  memory now */
                 free(rcvbuffer);
                 free(packet);
                 return (TRUE);
              } else {
                 /* We had a problem - We could check the error here if we wanted */
                 /*Lets free that rcvbuffer and packet  memory now */
                 free(rcvbuffer);
                 free(packet);
                 return (FALSE);
              }

          }
      } else {
          /* command still incomplete - We should do another read if neccessary to get all data */
          /*Lets free that rcvbuffer and packet  memory now */
          free(rcvbuffer);
          free(packet);
          return(FALSE);
      }   /* End if - Get entire packet */

   } else {
      /* Get intial read error ehre */
      sockerr = sock_errno();
      return(FALSE);
   }  /* End if - Recieved 1st byte */

}

void socketThread(void *serverArg) {
/* Well here it is. The server or receive thread...I call it hte server thread since
   is will be getting data FROM the server*/
   clientData *sData;
   int  recvSocket;
   char *nickname;
   HAB  habt;
   BOOL Connected;
   QMSG qmsg;          /* This will hold or messages from the queue */
   int  rc;             /* We will use this for generic return values of some functions */
   int  timeout;        /* This is the timeout for our select.*/
   int  socks[1];        /* This will hold our select socket array */
   char *packet;
   int  recvlen;
   int  pktremain;
   char *rcvbuffer;
   char pktlen[1];

   habt = WinInitialize(0);
   hmqt = WinCreateMsgQueue(habt, 15); /* This is a global variable rememebr */

   sData = (clientData*)serverArg;
   recvSocket = sData->SocketID;
   nickname = strdup(sData->nick);
   Connected = TRUE;

   /* We will let the server go about its merry way until we get a SM_CLOSE */
   while (Connected) {
      /* We will first check the message queue for any pending outgoing messages SM_SEND */
      if((rc = WinPeekMsg(habt, &qmsg, 0, 0, 0, PM_NOREMOVE)) == TRUE) {
         /* If we have a message we will call select for them first. */
         timeout = -1;   /* A timeout of -1 means NO timeout on the select.
                           I do this so we can wait till the socket is ready to send */
         socks[0] = recvSocket;
         if((rc = select(socks, 0, 1, 0, timeout)) > 0) {
               /* We have a ready socket. Make one more check to be sure by looking at socks */
               if (socks[0] == recvSocket) {
                   while (WinPeekMsg(habt, &qmsg, NULL, 0, 0, PM_REMOVE)) {
                      switch (qmsg.msg) {
                            case SM_SEND:
                                packet = (char*)qmsg.mp1;
                                /* The message mp1 is a pointer to the complete packet. We only need send it now */
                                rc = send(recvSocket, packet, packet[0]+1, 0);
                                free(packet);
                            break;

                            case SM_KILL:
                               /* We are to shutdown out socket and kill the thread */
                               if ((soclose(recvSocket)) == 0) {
                                  Connected = FALSE;
                               }
                            break;
                      } /* End switch */
                   } /* End while */
               } /* End if socks */
         } /* End if select */

         /* Lets find out what it is and process it */

      } /* End WinPeekMsg() */
      /* If still Connected */
      if (Connected) {
         /* Now we will set up the recv select() */
         socks[0] = recvSocket;
         timeout = 250;  /* This is 5 seconds */
         if((rc = select(socks, 1, 0, 0, timeout)) > 0) {
                  /* We have a ready socket. Make one more check to be sure by looking at socks */
                  if (socks[0] == recvSocket) {
                     /* Our socket has data to be read. Lets get it */
                     /* Get poacket length first */
                     if ((recvlen = recv(recvSocket, &pktlen, 1, 0)) > 0) {
                        pktremain = (int)pktlen[0] - 1;           /*Set this int to our packet len*/
                        if (pktremain > 0) {
                           rcvbuffer = malloc(pktremain + 1);
                           /*Lets make sure there is a null terminator at the end of the recieved packet */
                           /*rcvbuffer[pktremain+1] = '\0';  */
                           /* Now get the whole packet. Th eextra is to read in the lunn terminator */
                           if ((recvlen = recv(recvSocket, rcvbuffer, pktremain+1, 0)) < 0) {
                           /* We have a problem lets get the error here */
                             rc=sock_errno();
                           } else {
                           /* We got the whole packet */
                           } /*End if - Packet recv() was successful */

                           /* see if we read the whole thing */
                           if (((pktremain -= recvlen) +1) == 0) {
                              /* We got it..Now lets check to make sure we got a j code - and send our login */
                              switch (rcvbuffer[0]) {

                                 case 'b':
                                    /* Open message packet */
                                    WinPostMsg(hwndClient, SM_RECV, strdup(&rcvbuffer[1]),0);
                                    free(rcvbuffer);
                                 break;

                                 default:
                                    free(rcvbuffer);
                                 break;
                              } /* End switch */
                           } /* End if lengths are right */
                        } /* End if the legnth is > 0 */
                     } /* End if we get the length */
                  } /* End if socks */
         } /* End if select */
      } /* End if Connected */
   } /* End while connection loop */

   WinPostMsg(hwndClient, SM_DISCONNECTED, 0,0);
   WinTerminate(habt);
   _endthread();

}

