/***************************************************************************
 *
 * MODULE:	RMX Stopper application
 * SOURCE:	$Source$
 * OVERVIEW:	This file contains the implementation of rmxstop.exe,
 *              an application that stops a started rmxstrtr.
 *
 * Copyright (c) 1995 Johan Wikman (johan.wikman@ntc.nokia.com)
 *
 * $Log$
 *
 ****************************************************************************/

#define INCL_NOCOMMON
#define INCL_DOSERRORS
#define INCL_DOSSEMAPHORES
#include "rmxstart.h"
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include <os2.h>


const char* USAGE = "usage: rmxstop [-c dll]";


int main(int argc, char* argv[])
{
  if ((argc != 1) && (argc != 3))
    {
      cerr << USAGE << endl;
      return EXIT_INIT;
    }
  
  PCSZ
    pcszRmxComms = 0;
  
  if (argc == 1)
    {
      pcszRmxComms = getenv(RMXCOMMS);
      
      if (pcszRmxComms == 0)
	{
	  cerr << "rmxstop: No explicit DLL and environment variable "
	          "RMXCOMMS not specified." << endl;
	  return EXIT_INIT;
	}
    }
  else
    {
      if (strcmp(argv[1], "-c"))
	{
	  cerr << USAGE << endl;
	  return EXIT_INIT;
	}
      
      pcszRmxComms = argv[2];
    }
  
  CHAR
    achSemName[CCHMAXPATH];
  
  strcpy(achSemName, RMXSEMPREFIX);
  strcat(achSemName, pcszRmxComms);
  
  HEV
    hev = 0;

  if (DosOpenEventSem(achSemName, &hev) == NO_ERROR)
    {
      DosPostEventSem(hev);
      DosCloseEventSem(hev);
    }
  else
    {
      cerr << "rmxstop: No rmxstrtr using " << pcszRmxComms 
	   << " seems to be running."
	   << endl;
    }

  return EXIT_OK;
}
