//---------------------------------------------------------------------------------------------
// File TOOLBAR.CPP
//---------------------------------------------------------------------------------------------
#define INCL_WIN

#include <os2.h>
#include "toolbar.h"

MRESULT EXPENTRY ClientWndProc (HWND,ULONG,MPARAM,MPARAM);    // Window procedure
MRESULT EXPENTRY NewFrameProc  (HWND, ULONG ,MPARAM, MPARAM); // subclass framewindow

HAB   hab;
HWND  hwndFrame,
      hwndClient,
      hwndStatus,
      hwndToolbar,
      hwndMenu;

PFNWP pfnwOldFrameProc; // Pointer to normal Frame routine in kernel for subclassing

main()
     {
     HMQ   hmq;
     QMSG  qmsg;
     ULONG flFrameFlags = FCF_TITLEBAR |FCF_SYSMENU |FCF_SIZEBORDER |FCF_MINMAX |FCF_TASKLIST;
     CHAR  szClient[] = "CLIENT";

     hab = WinInitialize (0);
     hmq = WinCreateMsgQueue (hab, 0);

     WinRegisterClass (hab, szClient, ClientWndProc, CS_SIZEREDRAW, 0);

     // Create Frame window
     hwndFrame = WinCreateStdWindow (HWND_DESKTOP,
                                     WS_VISIBLE,
                                     &flFrameFlags,
                                     szClient,
                                     "Standard Window with statusbar and toolbar",
                                     0,
                                     NULLHANDLE,
                                     MAINMENU,
                                     &hwndClient);

      // Create statusbar window
      hwndStatus= WinCreateWindow(hwndFrame,
                                  WC_STATIC,
                                  " StatusBar",
                                  SS_TEXT| DT_VCENTER | WS_VISIBLE
                                  ,0, 0, 0, 0,       // client window has no size or position at this point
                                  hwndFrame,         // Owner handle
                                  HWND_TOP,          // Z-order ontop
                                  STATUSBAR,         // Window ID
                                  0,                 // Control
                                  0);                // Presentation Parameters


     //---------------------------------------------------------------------------------------------
     // Subclassing normal window proc
     //---------------------------------------------------------------------------------------------
     pfnwOldFrameProc = WinSubclassWindow(hwndFrame,NewFrameProc);  // subclass Framewin
     WinSetWindowULong(hwndFrame,QWL_USER,(ULONG)pfnwOldFrameProc); // Pointer to oldwinproc in winword

     hwndToolbar = WinLoadMenu(hwndFrame,NULLHANDLE,TOOLBAR);       // Load Toolbar
     hwndMenu    = WinLoadMenu(hwndFrame,NULLHANDLE,MAINMENU);      // Load normal window menu


     WinSetWindowPos(hwndFrame,
                     NULLHANDLE,
                     10,10,550,300,
                     SWP_ACTIVATE|SWP_MOVE|
                     SWP_SIZE    |SWP_SHOW);


     while (WinGetMsg (hab, &qmsg, 0, 0, 0))
           WinDispatchMsg (hab, &qmsg);

     WinDestroyWindow (hwndFrame);
     WinDestroyMsgQueue (hmq);
     WinTerminate (hab);
     return(0);
     }


MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {
     switch (msg)
          {
          case WM_PAINT:
               {
               RECTL rectl ;
               HPS   hps;

               hps = WinBeginPaint( hwnd, (HPS) NULL, &rectl );
               WinFillRect( hps, (PRECTL)&rectl, CLR_DARKPINK);
               WinEndPaint( hps );
               }
          break;
          }
     return (WinDefWindowProc (hwnd,msg,mp1,mp2));
     }


//-------------------------------------------------------------------------------------------------
// NewFrameProc
//
// this proc is coupled through subclassing to the original window proc of the framewindow.
// If the framewindow proc is called, for example if the framewindow is put on the screen,
// this proc is called first. At the end of this subclass the handle  is passed to the
// original proced.
//-------------------------------------------------------------------------------------------------
MRESULT EXPENTRY NewFrameProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {
     PFNWP   oldFrameProc ;
     oldFrameProc = (PFNWP) WinQueryWindowULong( hwnd, QWL_USER );      // Pointer from windowword

     switch (msg)
          {
          case WM_QUERYFRAMECTLCOUNT:
               {
               USHORT   itemCount;
               itemCount = SHORT1FROMMR(oldFrameProc(hwnd,msg,mp1,mp2)); //count frame controls
               return ( (MRESULT) (itemCount+2) );                       //add 2 for new controls               }

           case WM_FORMATFRAME :
               {
               USHORT itemCount = SHORT1FROMMR( oldFrameProc( hwnd, msg, mp1, mp2 ));
               USHORT usClient  = 0,
                      usMenu    = 0,
                      usToolbar = itemCount+1,
                      usStatus  = itemCount;

               PSWP pSWP = (PSWP)PVOIDFROMMP(mp1);

               while (pSWP[usClient].hwnd != WinWindowFromID(hwndFrame, FID_CLIENT))
                    ++usClient;
               while (pSWP[usMenu].hwnd != hwndMenu)
                    ++usMenu;

               // Fill in values for the Toolbar
               pSWP[usToolbar].hwnd = hwndToolbar;             // Window handle
               pSWP[usToolbar].hwndInsertBehind = HWND_TOP ;   // On which window (ONTOP)
               pSWP[usToolbar].fl = pSWP[usMenu].fl;           // SWP_SIZE style flag
               pSWP[usToolbar].cy = pSWP[usClient].cy;         // Heigth to client heigth
               pSWP[usToolbar].cx = pSWP[usClient].cx ;        // width is client width

               WinSendMsg(pSWP[usToolbar].hwnd,                // let the menu code make the adjustments(cy)
                          WM_ADJUSTWINDOWPOS,                  // Message WM_ADJUSTWINDOWPOS to hwndTool
                          MPFROMP(pSWP+usToolbar),             // mp1 == SWP struct of hwndTool
                           (MPARAM) 0L );                      // mp2 == Leeg
               // position Statusbar at bottom framewindow
               pSWP[usToolbar].x = pSWP[usMenu].x ;                      // XPOS in FRAME
               pSWP[usToolbar].y = pSWP[usMenu].y - pSWP[usToolbar].cy ; // YPOS in FRAME
               // adjust client window size for 2nd menu
               // If not, the client window will be placed over the statusbar
               pSWP[usClient].cy= pSWP[usClient].cy - pSWP[usToolbar].cy ;

               // Fill in values for the statusbar
               pSWP[usStatus].hwnd = hwndStatus;             // Window handle
               pSWP[usStatus].fl = SWP_SIZE | SWP_MOVE;      // SWP_SIZE style flag
               pSWP[usStatus].cy = pSWP[usMenu].cy;          // Heigth menu hoogte
               pSWP[usStatus].cx = pSWP[usMenu].cx ;         // width is menu width
               pSWP[usStatus].x = pSWP[usClient].x ;         // XPOS in FRAME
               pSWP[usStatus].y = pSWP[usClient].y ;         // YPOS in FRAME
               pSWP[usStatus].hwndInsertBehind = HWND_TOP ;  // On which window (ONTOP)
               // adjust client window size for 2nd menu
               // If not, the client window will be placed over the statusbar
               pSWP[usClient].cy= pSWP[usClient].cy - pSWP[usStatus].cy ;
               pSWP[usClient].y = pSWP[usStatus].y + pSWP[usStatus].cy ;
               // return total count of frame controls
               return( MRFROMSHORT(itemCount+2));
               }

          default:
               return oldFrameProc(hwnd,msg,mp1,mp2);
          }
     }

