//-------------------------------------------------------------------------------
// FILE: Spinbut4.cpp
//-------------------------------------------------------------------------------
#define  INCL_WIN
#include <os2.h>
#include <stdio.h>
#include <math.h>
#include "spinbut4.h"

//-------------------------------------------------------------------------------
// VARIABLES
//-------------------------------------------------------------------------------
PSZ     achValues[] = {"-0.01        ","0.00         ","0.01         "};
PFNWP   pfnwOldProc;
//-------------------------------------------------------------------------------
// Prototypes
//-------------------------------------------------------------------------------
MRESULT EXPENTRY SpinDlg  (HWND, ULONG ,MPARAM, MPARAM);
MRESULT EXPENTRY CalcSpin (HWND, ULONG ,MPARAM, MPARAM);
void  WriteSpin(HWND, ULONG, float);
float ReadSpin (HWND, ULONG);
//-------------------------------------------------------------------------------
// Main
//
// Sets up a simple dialogbox to demonstrate spinbuttons. By using a dialog
// none of the usual window control has to be included.
//-------------------------------------------------------------------------------
void main(void)
     {
     HAB  hab;
     HMQ  hmq;

     hab = WinInitialize(0);
     hmq = WinCreateMsgQueue(hab,0);

     WinDlgBox(HWND_DESKTOP,
               HWND_DESKTOP,
               SpinDlg,
               NULLHANDLE,
               SPINDLG,
               0);

     WinDestroyMsgQueue(hmq);
     WinTerminate(hab);
     }

//---------------------------------------------------------------------------------
// dialog procedure
//---------------------------------------------------------------------------------
MRESULT EXPENTRY SpinDlg(HWND hwndDlg, ULONG ulMsg, MPARAM mpParm1, MPARAM mpParm2)
     {
     switch (ulMsg)
          {
          case WM_INITDLG:
               {
               // Subclass the spinbutton with ClacSpin
               pfnwOldProc = WinSubclassWindow(WinWindowFromID(hwndDlg, SPINBUT1), CalcSpin);
               // Spinbut1 to predefined
               WinSendDlgItemMsg(hwndDlg, SPINBUT1, SPBM_SETARRAY, MPFROMP (achValues), MPFROMSHORT (3));
               // Make middle one current
               WinSendDlgItemMsg(hwndDlg, SPINBUT1, SPBM_SETCURRENTVALUE, MPFROMLONG (1), MPFROMLONG (0));
               }
          break;

          case WM_COMMAND:
               {
               switch (SHORT1FROMMP(mpParm1))
                    {
                    case READBUTTON:
                         {
                         char  achString[12];

                         sprintf(achString,"%.*f", 2, ReadSpin(hwndDlg, SPINBUT1));
                         WinSetWindowText(WinWindowFromID(hwndDlg, ENTRYFIELD), achString);
                         }
                    return MRFROMSHORT(TRUE);

                    case WRITEBUTTON:
                         {
                         char  achString[12];

                         WinQueryWindowText(WinWindowFromID(hwndDlg, ENTRYFIELD),
                                            sizeof(achString),
                                            achString);
                         WriteSpin(hwndDlg, SPINBUT1, atof(achString));
                         }
                    return MRFROMSHORT(TRUE);
                    }
               }
          }
     return WinDefDlgProc(hwndDlg, ulMsg, mpParm1, mpParm2);
     }

//---------------------------------------------------------------------------------
// Subclass for spinbutton
//---------------------------------------------------------------------------------
MRESULT EXPENTRY CalcSpin(HWND hwndDlg, ULONG ulMsg, MPARAM mpParm1, MPARAM mpParm2)
     {
     if (ulMsg == SPBM_SPINUP || ulMsg == SPBM_SPINDOWN)
          {
          float  flSpinValue, factor;
          char   chSpinValue[12];

          WinQueryWindowText(WinQueryWindow(hwndDlg,QW_TOP),12,chSpinValue);
          flSpinValue = atof(chSpinValue);
          //-----------------------------------------------------------------------
          // Set the multiplication factor
          //-----------------------------------------------------------------------
          if (fabs(flSpinValue) < 1)
               factor = 0.01;
          else
               factor = (float) ceil(fabs(flSpinValue/50));

          sprintf(achValues[0],"%.*f", 2, flSpinValue + -factor);
          sprintf(achValues[1],"%.*f", 2, flSpinValue + 0);
          sprintf(achValues[2],"%.*f", 2, flSpinValue + factor);

          //-----------------------------------------------------------------------
          // Set the new array for the spinbutton and make the middle item the
          // cuurent one so the user can go up or down.
          //-----------------------------------------------------------------------
          pfnwOldProc(hwndDlg, SPBM_SETARRAY, MPFROMP (achValues), MPFROMSHORT(3));
          pfnwOldProc(hwndDlg, SPBM_SETCURRENTVALUE, (MPARAM)1, (MPARAM)0);
          }
     return pfnwOldProc(hwndDlg, ulMsg, mpParm1, mpParm2);
     }

//--------------------------------------------------------------------------------------------------
// ReadSpin
//
// Read the value in the sle field of the and return the float equevalent
//--------------------------------------------------------------------------------------------------
float ReadSpin(HWND hwndDlg, ULONG ulId)
     {
     HWND  hwndSpinSle;                                      // Handle off sb sle field (child sb)
     HWND  hwndSpinbut;                                      // Handle Spin button
     char  Output[16];

     hwndSpinbut = WinWindowFromID(hwndDlg, ulId);           // Query spinbutton handle
     hwndSpinSle = WinQueryWindow(hwndSpinbut, QW_TOP);      // Query first child spinbuuton (= entry field)
     WinQueryWindowText(hwndSpinSle, 16, Output);

     return (atof(Output));
     }

//--------------------------------------------------------------------------------------------------
// WriteSpin
//
// Write the float value in Input as a char[12] in the sle of a Spinbutton
//--------------------------------------------------------------------------------------------------
void WriteSpin(HWND hwndDlg, ULONG ulId, float WriteValue)
     {
     char  Value[16];

     sprintf(Value,"%.*f", 2, WriteValue);
     WinSetWindowText(WinQueryWindow(WinWindowFromID(hwndDlg, ulId), QW_TOP), Value);
     }

