#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

SHORT EXPENTRY writeBinaryData(FILE *pfFile,
                               PVOID pvBuf,
                               USHORT usSzBuf)
//-------------------------------------------------------------------------
// This function writes the binary data in hexadecimal/ASCII format (a la
// Norton's disk editor) to the specified file.
//
// Input:  pfFile - points to the FILE structure
//         pvBuf - points to the data to be written
//         usSzBuf - specifies the size of the buffer pointed to by pvBuf
// Returns:  number of characters written if successful, -1 otherwise
//-------------------------------------------------------------------------
{
   USHORT usOffset;
   CHAR achChars[32];
   USHORT usLine;

   for (usOffset=0; usOffset<usSzBuf; usOffset+=16) {
      memset(achChars,0,sizeof(achChars));
      fprintf(pfFile,"  ");

      for (usLine=usOffset; usLine<usOffset+16; usLine++) {
         if (usLine<usSzBuf) {
            fprintf(pfFile,"%02X ",((PBYTE)pvBuf)[usLine]);

            if (isprint(((PCHAR)pvBuf)[usLine])) {
               achChars[usLine-usOffset]=((PCHAR)pvBuf)[usLine];
            } else {
               achChars[usLine-usOffset]='.';
            } /* endif */
         } else {
            fprintf(pfFile,"   ");
            achChars[usLine-usOffset]=' ';
         } /* endif */
      } /* endfor */

      fprintf(pfFile,"| %s\n",achChars);
   } /* endfor */

   fflush(pfFile);
   return usSzBuf;
}
