#define INCL_GPIBITMAPS
#define INCL_WINFRAMEMGR
#define INCL_WININPUT
#define INCL_WINTIMER
#include <os2.h>
#define INCL_COMMONALL
#include <common.h>
#include "rc.h"

#define CLS_CLIENT               "collideClass"

#define TID_SPRITE               1

#define SPRITE_DX                3
#define SPRITE_DY                3

HAB habAnchor;
HCSPLAYGROUND hpPlay;
HCSSPRITE hsSprite1;
HCSSPRITE hsSprite2;
BOOL bStarted;

VOID setInitialPos(HPS hpsWnd)
{
   static BOOL bTop=TRUE;
   POINTL ptlPos;
   SIZEL szlPlay;
   SIZEL szlSprite;

   ptlPos.x=0;
   ptlPos.y=0;

   CmnSprSetSpritePosition(hpsWnd,hsSprite1,&ptlPos);

   CmnSprQueryPlaygroundSize(hpPlay,&szlPlay);
   CmnSprQuerySpriteSize(hsSprite2,&szlSprite);

   ptlPos.x=szlPlay.cx-szlSprite.cx-1;
   ptlPos.y=szlPlay.cy-szlSprite.cy-1;

   CmnSprSetSpritePosition(hpsWnd,hsSprite2,&ptlPos);

   if (bTop) {
      CmnSprSetLayering(hpsWnd,hsSprite2,SSL_TOP);
      bTop=FALSE;
   } else {
      CmnSprSetLayering(hpsWnd,hsSprite1,SSL_TOP);
      bTop=TRUE;
   } /* endif */
}

MRESULT EXPENTRY wndProc(HWND hwndWnd,
                         ULONG ulMsg,
                         MPARAM mpParm1,
                         MPARAM mpParm2)
{
   switch (ulMsg) {
   case WM_CREATE:
      {
         HPS hpsWnd;
         HBITMAP hbmBitmap;
         SIZEL szlPlay;
         RECTL rclClient;

         if (CmnSprCreatePlayground(habAnchor,&hpPlay)!=SPR_ERR_NOERROR) {
            WinAlarm(HWND_DESKTOP,WA_ERROR);
            return MRFROMSHORT(FALSE);
         } /* endif */

         hpsWnd=WinGetPS(hwndWnd);

         hbmBitmap=GpiLoadBitmap(hpsWnd,NULLHANDLE,BMP_BACK,0,0);

         CmnSprSetPlaygroundBack(hpPlay,hbmBitmap,NULL);

         hbmBitmap=GpiLoadBitmap(hpsWnd,NULLHANDLE,BMP_SPRITE1,0,0);

         if (CmnSprCreateSprite(habAnchor,
                                hbmBitmap,
                                &hsSprite1)!=SPR_ERR_NOERROR) {
            CmnSprDestroyPlayground(hpPlay);
            WinAlarm(HWND_DESKTOP,WA_ERROR);
            return MRFROMSHORT(FALSE);
         } /* endif */

         CmnSprAddSprite(hpPlay,hsSprite1);

         CmnSprSetSpriteVisibility(hpsWnd,hsSprite1,TRUE);

         hbmBitmap=GpiLoadBitmap(hpsWnd,NULLHANDLE,BMP_SPRITE2,0,0);

         if (CmnSprCreateSprite(habAnchor,
                                hbmBitmap,
                                &hsSprite2)!=SPR_ERR_NOERROR) {
            CmnSprDestroyPlayground(hpPlay);
            WinAlarm(HWND_DESKTOP,WA_ERROR);
            return MRFROMSHORT(FALSE);
         } /* endif */

         CmnSprAddSprite(hpPlay,hsSprite2);

         CmnSprSetSpriteVisibility(hpsWnd,hsSprite2,TRUE);

         setInitialPos(hpsWnd);

         WinReleasePS(hpsWnd);

         CmnSprQueryPlaygroundSize(hpPlay,&szlPlay);

         rclClient.xLeft=0;
         rclClient.yBottom=0;
         rclClient.xRight=szlPlay.cx;
         rclClient.yTop=szlPlay.cy;

         WinCalcFrameRect(WinQueryWindow(hwndWnd,QW_PARENT),&rclClient,FALSE);

         WinSetWindowPos(WinQueryWindow(hwndWnd,QW_PARENT),
                         NULLHANDLE,
                         100,
                         100,
                         rclClient.xRight-rclClient.xLeft,
                         rclClient.yTop-rclClient.yBottom,
                         SWP_MOVE|SWP_SIZE|SWP_SHOW|SWP_ACTIVATE);

         WinStartTimer(habAnchor,hwndWnd,TID_SPRITE,50);
         bStarted=TRUE;
      }
      break;
   case WM_DESTROY:
      CmnSprDestroyPlayground(hpPlay);
      break;
   case WM_BUTTON1DOWN:
      if (bStarted) {
         WinStopTimer(habAnchor,hwndWnd,TID_SPRITE);
         bStarted=FALSE;
      } else {
         WinStartTimer(habAnchor,hwndWnd,TID_SPRITE,50);
         bStarted=TRUE;
      } /* endif */
      break;
   case WM_BUTTON2DOWN:
      if (bStarted) {
         WinStopTimer(habAnchor,hwndWnd,TID_SPRITE);
         bStarted=FALSE;
      } /* endif */

      WinSendMsg(hwndWnd,WM_TIMER,MPFROMSHORT(TID_SPRITE),0);
      break;
   case WM_TIMER:
      {
         HPS hpsWnd;
         POINTL ptlPos;
         SIZEL szlSprite;

         hpsWnd=WinGetPS(hwndWnd);

         CmnSprQuerySpritePosition(hsSprite1,&ptlPos);

         ptlPos.x+=SPRITE_DX;
         ptlPos.y+=SPRITE_DY;

         CmnSprSetSpritePosition(hpsWnd,hsSprite1,&ptlPos);

         CmnSprQuerySpritePosition(hsSprite2,&ptlPos);

         ptlPos.x-=SPRITE_DX;
         ptlPos.y-=SPRITE_DY;

         CmnSprSetSpritePosition(hpsWnd,hsSprite2,&ptlPos);

         CmnSprQuerySpriteSize(hsSprite2,&szlSprite);

         if ((ptlPos.x<-szlSprite.cx) || (ptlPos.y<-szlSprite.cy)) {
            setInitialPos(hpsWnd);
         } /* endif */

         WinReleasePS(hpsWnd);
      }
      break;
   case WM_PAINT:
      {
         HPS hpsPaint;

         hpsPaint=WinBeginPaint(hwndWnd,NULLHANDLE,NULL);
         GpiErase(hpsPaint);
         CmnSprDrawPlayground(hpsPaint,hpPlay);
         WinEndPaint(hpsPaint);
      }
      break;
   default:
      return WinDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
   } /* endswitch */

   return MRFROMSHORT(FALSE);
}

INT main(VOID)
{
   HMQ hmqQueue;
   ULONG ulFrame;
   HWND hwndFrame;
   HWND hwndClient;
   BOOL bLoop;
   QMSG qmMsg;

   habAnchor=WinInitialize(0);
   hmqQueue=WinCreateMsgQueue(habAnchor,0);

   WinRegisterClass(habAnchor,CLS_CLIENT,wndProc,CS_SIZEREDRAW,sizeof(PVOID));

   ulFrame=FCF_SYSMENU | FCF_TITLEBAR | FCF_SIZEBORDER |
              FCF_TASKLIST | FCF_ICON;

   hwndFrame=WinCreateStdWindow(HWND_DESKTOP,
                                0,
                                &ulFrame,
                                CLS_CLIENT,
                                "Collision Test",
                                0,
                                NULLHANDLE,
                                RES_CLIENT,
                                &hwndClient);
   if (hwndFrame!=NULLHANDLE) {
      bLoop=WinGetMsg(habAnchor,&qmMsg,NULLHANDLE,0,0);
      while (bLoop) {
         WinDispatchMsg(habAnchor,&qmMsg);
         bLoop=WinGetMsg(habAnchor,&qmMsg,NULLHANDLE,0,0);
      } /* endwhile */

      WinDestroyWindow(hwndFrame);
   } /* endif */

   WinDestroyMsgQueue(hmqQueue);
   WinTerminate(habAnchor);
   return 0;
}
