include 'saveall.e'


defc gocol
    .col = arg(1)

 
/* For the autoload feature we maintain a list of the currently open files in a profile entry named 
   STARTUP_FILES. The first one is the file actually edited to make shure it comes up on restart */
 
defselect                                  /* This one makes shure that the file that was on top on
                                              shutdown will reappear there on startup. Defselects are
                                              called whenever a file is selected */
   universal appname, app_hini              /* The application name and INI-handle
                                               are stored in these global variables */
   psave_pos(spos)                          -- Save cursor position
   filelist = queryprofile( $HINI_PARM appname, 'STARTUP_FILES')    -- get actual filelist
   if wordpos(.filename, filelist) then                             -- find actual file
      filelist = delword(filelist, wordpos(.filename, filelist), 1) -- and remove it
   endif
   if (not wordpos(.filename, filelist)) and (substr(.filename, lastpos('\', .filename) + 1, 1) <> '.') then
       filelist = .filename' 'filelist                              -- add the actual filename at the beginning
   endif
   setprofile( $HINI_PARM appname, 'STARTUP_FILES', filelist )      -- write the new list to the INI-file
   prestore_pos(spos)                       -- Restore cursor position


defproc postsave_exit (fname)                                       -- called just after file was saved
   universal appname, app_hini, oldfile                             /* oldfile is the old filename if
                                                                       file was renamed */
   psave_pos(spos)                          -- Save cursor position
   filelist = queryprofile( $HINI_PARM appname, 'STARTUP_FILES')    -- get the old file list
   if wordpos(oldfile, filelist) then                               -- if old filename is in the list
       filelist = delword(filelist, wordpos(oldfile, filelist), 1)  -- delete it
   endif
   if (not wordpos(fname, filelist)) and (substr(fname, lastpos('\', fname) + 1, 1) <> '.') then
       filelist = fname' 'filelist      -- Add actual filename if its not a tempfile ('.---')
                                        -- remove the 'and (substr...' section if you want to restart temp files
   endif
   setprofile( $HINI_PARM appname, 'STARTUP_FILES', filelist )      -- store the new list
   prestore_pos(spos)                       -- Restore cursor position


defproc rename_exit (oldfile, fname)                                -- called if file was renamed
   universal appname, app_hini
   psave_pos(spos)                          -- Save cursor position
   filelist = queryprofile( $HINI_PARM appname, 'STARTUP_FILES')    -- same as for postsave_exit
   if wordpos(oldfile, filelist) then
      filelist = delword(filelist, wordpos(oldfile, filelist), 1)
   endif
   if (not wordpos(fname, filelist)) and (substr(fname, lastpos('\', fname) + 1, 1) <> '.') then
       filelist = fname' 'filelist
   endif
   setprofile( $HINI_PARM appname, 'STARTUP_FILES', filelist )
   prestore_pos(spos)                       -- Restore cursor position


defproc quit_exit (fname)                                           -- called if file is closed
   universal appname, app_hini
   filelist = queryprofile( $HINI_PARM appname, 'STARTUP_FILES')    -- just delete entry
   if wordpos(fname, filelist) then
      filelist = delword(filelist, wordpos(fname, filelist), 1)
   endif
   setprofile( $HINI_PARM appname, 'STARTUP_FILES', filelist )
 

-- Defload functions are called whenever a file was loaded

defload                         /* same as for namefile and savefile,
                                   just that there are no old names to delete */
   universal appname, app_hini
   filelist = queryprofile( $HINI_PARM appname, 'STARTUP_FILES')
   if (not wordpos(.filename, filelist)) and (substr(.filename, lastpos('\', .filename) + 1, 1) <> '.') then
       filelist = .filename' 'filelist
   endif
   setprofile( $HINI_PARM appname, 'STARTUP_FILES', filelist )
 


/* Here comes the Cursor position feature */

defproc presave_exit            -- issued just before a file is saved
   universal oldfile            -- used to store the filename for postsave_exit
   delete_ea('EPM.POS')         -- delete old 'EPM.POS' entry in the EAs
   psave_pos(screenpos)         -- get cursor and screen position,...
   'addea EPM.POS' screenpos    -- and store it in the EA
   oldfile = .filename          -- this one's needed for the restart feature


defload             -- This one's for setting the Cursor and window position for the loaded file 
    if find_ea('EPM.POS', ea_seg, ea_ofs, ea_ptr1, ea_ptr2, ea_len, ea_entrylen, ea_valuelen) then
        -- if there's an EPM.POS EA...
        getfileid myid          -- that's the actual file
        'postme restore_ORG_pos 'myid get_EAT_ASCII_value('EPM.POS')
         /* restore postions. have to post it 'cause the screen may not yet be painted.
            Also I had to make this the last of my defloads to make it work correctly */
    endif


defc restore_ORG_pos    -- This sets the cursor and screen-positions. It does the same as 
                        -- prestore_pos except for being passed the fileid as first parameter 
        parse value arg(1) with myid fline fcol cx cy
        myid.cursorx = cx
        myid.cursory = cy
        myid.line = fline
        myid.col = fcol

