;
; $Header: D:/32bits/ext2-os2/fsh32/RCS/fsh32_findduphvpb.asm,v 1.1 1996/08/26 19:02:51 Willm Exp Willm $
;

; 32 bits OS/2 device driver and IFS support driver. Provides 32 bits kernel 
; services (DevHelp) and utility functions to 32 bits OS/2 ring 0 code 
; (device drivers and installable file system drivers).
; Copyright (C) 1995, 1996 Matthieu WILLM
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        .386p

        INCL_DOSERRORS equ 1
        include bseerr.inc
        include devhlp.inc
        include segdef.inc
        include r0thunk.inc

CODE16 segment
        ASSUME CS:CODE16, DS:FLAT

        extrn FSH_FINDDUPHVPB : far

        public thunk16$fsh32_findduphvpb

thunk16$fsh32_findduphvpb:
        call FSH_FINDDUPHVPB
;        jmp far ptr FLAT:thunk32$fsh32_findduphvpb
        jmp32 thunk32$fsh32_findduphvpb

CODE16 ends

CODE32 segment
ASSUME CS:FLAT, DS:FLAT, ES:FLAT, SS:NOTHING

        public thunk32$fsh32_findduphvpb
        public         fsh32_findduphvpb

;
; int FSH32ENTRY fsh32_findduphvpb(
;                                 unsigned short hVPB,         /* ebp + 8  */
;                                 unsigned short *phVPB        /* ebp + 12 */
;                                );
;
fsh32_findduphvpb proc near
        enter 2, 0
;
; ebp - 2 : tmphVPB (word)
;
	push es
        push ebx
        sub esp, 6
        mov ax, [ebp + 8]               ; hVPB
        mov [esp + 4], ax
        mov eax, ss
        mov [esp + 2], ax               ; seg tmphvpb
        lea eax, [ebp - 2]
        mov [esp], ax                   ; ofs tmphvpb
        jmp far ptr thunk16$fsh32_findduphvpb
thunk32$fsh32_findduphvpb:
        movzx eax, ax
        cmp eax, NO_ERROR
        jnz short @@error
        mov ax, [ebp - 2]
        mov ebx, [ebp + 12]
        mov [ebx], ax
        mov eax, NO_ERROR
@@error:
        pop ebx
	pop es
        leave
        ret
fsh32_findduphvpb endp

CODE32  ends

        end
