{}
{                                                       }
{      Virtual Pascal Run-time Library v1.1             }
{      BGI Graphics unit for mixed BGI/Textmode         }
{      }
{      Copyright (C) 1996 fPrint UK Ltd                 }
{      Written May-July 1996 by Allan Mertner           }
{        Inspired by DIVERace by Michael Mrosowski      }
{        Pipe interface engineered by Alex Vermeulen    }
{                                                       }
{}

Unit Graph;

Interface

Uses
  Use32;

type
  Str12 = String[12];

Const
  grOk                =  0;  // error status values reported by graphresult }
  grNoInitGraph       = -1;  // BGI graphics not installed
  grNotDetected       = -2;  // Graphics hardware not detected
  grFileNotFound      = -3;  // Device driver file not found
  grInvalidDriver     = -4;  // Invalid device driver file
  grNoLoadMem         = -5;  // Not enough memory to load driver
  grNoScanMem         = -6;  // Out of memory in scan fill
  grNoFloodMem        = -7;  // Out of memory in flood fill
  grFontNotFound      = -8;  // Font file not found
  grNoFontMem         = -9;  // Not enough memory to load font
  grInvalidMode       = -10; // Invalid graphics mode for selected driver
  grError             = -11; // Graphics error (generic error)
  grIOerror           = -12; // Graphics I/O error
  grInvalidFont       = -13; // Invalid font file
  grInvalidFontNum    = -14; // Invalid font number

  Detect              = 0;
  Black               = 0;   // Colour values
  Blue                = 1;
  Green               = 2;
  Cyan                = 3;
  Red                 = 4;
  Magenta             = 5;
  Brown               = 6;
  LightGray           = 7;
  DarkGray            = 8;
  LightBlue           = 9;
  LightGreen          = 10;
  LightCyan           = 11;
  LightRed            = 12;
  LightMagenta        = 13;
  Yellow              = 14;
  White               = 15;
  EGA_Black           = 0;   // different than DOS BGI values
  EGA_Blue            = 1;
  EGA_Green           = 2;
  EGA_Cyan            = 3;
  EGA_Red             = 4;
  EGA_Magenta         = 5;
  EGA_Brown           = 6;
  EGA_LightGray       = 7;
  EGA_DarkGray        = 8;
  EGA_LightBlue       = 9;
  EGA_LightGreen      = 10;
  EGA_LightCyan       = 11;
  EGA_LightRed        = 12;
  EGA_LightMagenta    = 13;
  EGA_Yello           = 14;
  EGA_White           = 15;

  NormWidth           = 1;   // constants for line thickness
  ThickWidth          = 3;

  SolidLn             = 0;   // constants for line patterns
  DottedLn            = 1;
  CenterLn            = 2;
  DashedLn            = 3;
  UserBitLn           = 4;

  DefaultFont         = 0;   // font constants for settextstyle
  TriplexFont         = 1;
  SmallFont           = 2;
  SansSerifFont       = 3;
  GothicFont          = 4;
  ScriptFont          = 5;
  SimplexFont         = 6;
  TriplexScrFont      = 7;
  ComplexFont         = 8;
  EuropeanFont        = 9;
  BoldFont            = 10;
  FontNames : Array[1..10] of Str12
            = ( 'TRIP.CHR', 'LITT.CHR', 'SANS.CHR', 'GOTH.CHR', 'SCRI.CHR',
                'SIMP.CHR', 'TSCR.CHR', 'LCOM.CHR', 'EURO.CHR', 'BOLD.CHR' );

  HorizDir            =  0;
  VertDir             =  90;
  UserCharSize        =  0;

  ClipOn              =  TRUE;
  ClipOff             =  FALSE;

  TopOn               =  TRUE;
  TopOff              =  FALSE;

  EmptyFill           = 0;   // fill patterns
  SolidFill           = 1;
  LineFill            = 2;
  LtSlashFill         = 3;
  SlashFill           = 4;
  BkSlashFill         = 5;
  LtBkSlashFill       = 6;
  HatchFill           = 7;
  XHatchFill          = 8;
  InterleaveFill      = 9;
  WideDotFill         = 10;
  CloseDotFill        = 11;
  UserFill            = 12;

  NormalPut           = 0;   // operators for image blits and setwritemode
  CopyPut             = 0;
  XORPut              = 1;
  OrPut               = 2;
  AndPut              = 3;
  NotPut              = 4;

  LeftText            = 0;   // text justification constants
  CenterText          = 1;
  RightText           = 2;
  BottomText          = 0;
  TopText             = 2;

  MaxColors           = 255; // Different from DOS

  LinePatterns        : Array[0..3] of Word
                      = ( $FFFFFFFF, $33333333, $3CCF3CCF, $0F0F0F0F );

type
  str4 = String[4];
  FillPatternType       = array [1..8] of Byte;
  NewPatternType        = array [0..15] of SmallWord;
  IntArray              = array [0..65000] of Integer;

  PaletteType           = record
                              Size    : word;
                              Colors  : array [0..MaxColors] of Byte;
                          end;

  LineSettingsType      = record
                              LineStyle : Word;
                              Pattern   : Word;
                              Thickness : Word;
                          end;

  TextSettingsType      = record
                              Font      : Word;
                              Direction : Word;
                              CharSize  : Integer;      { different than DOS BGI }
                              Horiz     : Word;
                              Vert      : Word;
                              userxscale: double;
                              useryscale: double;
                          end;

  FillSettingsType      = record
                              Pattern   : Word;
                              Color     : Word;
                          end;

  PointType             = record
                              X         : Integer;
                              Y         : Integer;
                          end;
  PointArray = Array[0..65000] of PointType;

  ViewPortType          = record
                              X1        : Integer;
                              Y1        : Integer;
                              X2        : Integer;
                              Y2        : Integer;
                              Clip      : Boolean;
                          end;

  ArcCoordsType         = record
                              X         : Integer;
                              Y         : Integer;
                              Xstart    : Integer;
                              Ystart    : Integer;
                              Xend      : Integer;
                              Yend      : Integer;
                          end;

  MouseStatusType       = record
                              X         : Integer;
                              Y         : Integer;
                              LButt     : Integer;
                              MButt     : Integer;
                              RButt     : Integer;
                              NewInfo   : Integer;
                          end;

{ BGI Function Prototypes }

Procedure Arc(X, Y: Integer; StAngle, EndAngle, Radius: Word);
Procedure Bar(X1, Y1, X2, Y2: Integer);
Procedure Bar3D(X1, Y1, X2, Y2: Integer; Depth: Word; Top: Boolean);
Procedure Circle(X, Y: Integer; Radius: Word);
Procedure ClearDevice;
Procedure ClearViewport;
Procedure CloseGraph;
procedure DetectGraph(var GraphDriver, GraphMode: Integer);
Procedure DrawPoly(NumPoints: Word; var PolyPoints);
Procedure Ellipse(X, Y: Integer; StAngle, EndAngle: Word; XRadius, YRadius: Word);
Procedure FillEllipse(X, Y: Integer; XRadius, YRadius: Word);
Procedure FillPoly(NumPoints: Word; var PolyPoints);
Procedure FloodFill(X, Y: Integer; Border: Word);
Procedure GetArcCoords(var ArcCoords: ArcCoordsType);
Procedure GetAspectRatio(var Xasp, Yasp: Word);
Function  GetBkColor: Word;
Function  GetColor: Word;
Procedure GetDefaultPalette(var Palette: PaletteType);
Function  GetDriverName: string;
Procedure GetFillPattern(var FillPattern: FillPatternType);
Procedure GetFillSettings(var FillInfo: FillSettingsType);
function  GetGraphMode: Integer;
procedure GetImage(x1, y1, x2, y2: Integer; var BitMap);
Procedure GetLineSettings(var LineInfo: LineSettingsType);
Function  GetMaxColor: Word;
Function  GetMaxX: Word;
Function  GetMaxY: Word;
Function  GetModeName(ModeNumber: Integer): string;
Procedure GetPalette(var Palette: PaletteType);
Function  GetPaletteSize: Integer;
Function  GetPixel(X,Y: Integer): Word;
Procedure GetTextSettings(var TextInfo: TextSettingsType);
Procedure GetViewSettings(var ThisViewPort: ViewPortType);
Function  GetX: Integer;
Function  GetY: Integer;
Procedure GraphDefaults;
Function  GraphErrorMsg(ErrorCode: Integer): String;
Function  GraphResult: Integer;
function  ImageSize(x1, y1, x2, y2: Integer): Word;
procedure InitGraph(var GraphDriver:Integer; var GraphMode: Integer;
    PathToDriver: string);
Function  InstallUserFont(FontFileName: string) : Integer;
Procedure Line(X1, Y1, X2, Y2: Integer);
Procedure LineRel(Dx, Dy: Integer);
Procedure LineTo(X, Y: Integer);
Procedure MoveRel(Dx, Dy: Integer);
Procedure MoveTo(X, Y: Integer);
Procedure OutText(TextString: string);
Procedure OutTextXY(X, Y: Integer; TextString: string);
Procedure PieSlice(X, Y: Integer; StAngle, EndAngle, Radius: Word);
procedure PutImage(X, Y: Integer; var BitMap; BitBlt: Word);
Procedure PutPixel(X, Y: Integer; Color: Word);
Procedure Rectangle(X1, Y1, X2, Y2: Integer);
Procedure RegisterBGIFont(FontID: Integer; Font: Pointer);
Procedure Sector(X, Y: Integer; StAngle, EndAngle, XRadius, YRadius: Word);
Procedure SetAllPalette(var Palette: PaletteType);
Procedure SetAspectRatio(Xasp, Yasp: Word);
Procedure SetBkColor(ColorNum: Word);
Procedure SetColor(Color: Word);
Procedure SetFillPattern(Pattern: FillPatternType; Color: Word);
Procedure SetFillStyle(Pattern: Word; Color: Word);
Procedure SetLineStyle(LineStyle: Word; Pattern: Word; Thickness: Word);
Procedure SetPalette(ColorNum: Word; Color: Byte);
Procedure SetRGBPalette(ColorNum: Word; Red, Green, Blue: Byte);
Procedure SetTextJustify(Horiz, Vert: Word);
Procedure SetTextStyle(Font, Direction, CharSize: Integer);
Procedure SetUserCharSize(MultX, DivX, MultY, DivY: Word);
Procedure SetViewPort(X1, Y1, X2, Y2: Integer; Clip: Boolean);
Procedure SetWriteMode(WriteMode: Integer);
Function  TextHeight(TextString: string): Word;
Function  TextWidth(TextString: string): Word;

// VP additional BGI functions
procedure SetWideFillPattern(Pattern: NewPatternType; Color: Word);
procedure FlushDisplay;              // Update BGI screen

// VP functions replacing CRT functions
function Keypressed: Boolean;        // Keypressed for both Server and Client
function ReadKey: Char;

// VP constants modifying behaviour of Graph
const
  WaitKeypressed  : Boolean = True;  // Delay() when calling keypressed
  AutoStartServer : Boolean = True;  // Start BGI server proces in InitGraph

{$IFDEF DEBUG}
procedure log( s: String );
{$ENDIF}

Implementation

uses Os2Def, Os2Base, Crt, Dos, BGIMsg, VPUtils;

const
  Stopping  : boolean = false;
  tid_BGI   : tid = 0;     // BGI Update Thread
  tid_Kbd   : tid = 0;     // Keyboard watch thread
  mtx_BGI   : hMTX = 0;    // BGI Update semaphore
  KeyCount  : Integer = 0; // Count of keys in KeyBuffer

var
  F         : File;
  DispPtr   : word;
  DispList  : DisplayListT;
  com       : CommandListT;
  bgires    : BGIResArT;
  KeyBuffer : array[0..127] of Char; // Keyboard type-ahead buffer

procedure waitforpipe;
var
  cnt,
  res : word;
begin
  if filerec(f).Handle > 0 then exit;
  cnt:=0;
  repeat
    inc(cnt);
    if cnt>1000 then
      Halt(22);
    {$I-}
    Reset(f,1);
    {$I+}
    res:=IOREsult;
    if res<>0 then
      DosSleep(50);
  until Res=0;
end;

procedure flushdisplay;
var
  ulWritten,
  ulRead,
  result : word;
begin
  if DispPtr=0 then Exit;
  if DosRequestMutexSem( mtx_BGI, 0 ) <> 0 then
    exit;  // Not important to update display - exit

  if DispPtr=0 then
    begin
      // If display has been updated, exit
      DosReleaseMutexSem( mtx_BGI );
      exit;
    end;
  waitforpipe;
{$I-}
  BlockWrite(F,displist,DispPtr*Sizeof(word),ulWritten);
  BlockRead(F,result,sizeof(result),ulRead);
  DispPtr:=0;
//  Close(F);
{$I+}
  if ioresult = 0 then ;
  DosReleaseMutexSem( mtx_BGI );
end;

procedure askbgi(func,nrpar,nrret:word);
var
  t,
  ulWritten,
  ulRead : word;
  snd    : array [0..2] of word;
begin
  flushdisplay;

  While DosRequestMutexSem( mtx_BGI, 90 ) <> 0 do
    DosSleep( 31 );
  DispList.w[DispPtr]:=func;
  DispList.w[DispPtr+1]:=nrpar;
  DispList.w[DispPtr+2]:=nrret;
  for t:=0 to nrpar-1 do
    DispList.i[DispPtr+t+3]:=com.i[t];
  waitforpipe;
  BlockWrite(F,displist,(nrpar+3)*sizeof(word),ulWritten);
  if nrret>0 then
    BlockRead(F,bgires,nrret*sizeof(word),ulRead);
  DispPtr:=0;
  DosReleaseMutexSem( mtx_BGI );
end;

procedure callbgi(func,nrpar:byte);
var
  t : word;
begin
  if DispPtr+NrPar+3>MaxDisp then
    flushdisplay;

  While DosRequestMutexSem( mtx_BGI, 50 ) <> 0 do
    DosSleep( 31 );
  DispList.w[DispPtr]:=func;
  DispList.w[DispPtr+1]:=nrpar;
  DispList.w[DispPtr+2]:=0;
  for t:=0 to nrpar-1 do
    DispList.i[DispPtr+t+3]:=com.i[t];
  DispPtr:=DispPtr+nrpar+3;
  DosReleaseMutexSem( mtx_BGI );
end;

Procedure Arc(X, Y: Integer; StAngle, EndAngle, Radius: Word);
begin
  com.i[0]:=x;com.i[1]:=y;
  com.w[2]:=StAngle;com.w[3]:=EndAngle;com.w[4]:=Radius;
  callbgi(1,5);
end;

Procedure Bar(X1, Y1, X2, Y2: Integer);
begin
  com.i[0]:=x1;com.i[1]:=y1;
  com.i[2]:=x2;com.i[3]:=y2;
  callbgi(2,4);
end;

Procedure Bar3D(X1, Y1, X2, Y2: Integer; Depth: Word; Top: Boolean);
begin
  com.i[0]:=x1;com.i[1]:=y1;
  com.i[2]:=x2;com.i[3]:=y2;
  com.w[4]:=Depth;if Top then com.w[5]:=1 else com.w[5]:=1;
  callbgi(3,6);
end;

Procedure Circle(X, Y: Integer; Radius: Word);
begin
  com.i[0]:=x;com.i[1]:=y;
  com.w[2]:=Radius;
  callbgi(4,3);
end;

Procedure ClearDevice;
begin
  callbgi(5,0);
end;

Procedure ClearViewport;
begin
  callbgi(6,0);
end;

Procedure CloseGraph;
begin
  if tid_BGI = 0 then Exit;

  callbgi(7,0);  // CloseGraph() call to Server Process

  Stopping := True;
  DosWaitThread( tid_BGI, dcww_Wait );
  tid_BGI := 0;
  DosCloseMutexSem( mtx_BGI );
end;

procedure DetectGraph(var GraphDriver, GraphMode: Integer);
begin
  askbgi(8,0,2);
  GraphDriver:=bgires[0];GraphMode:=bgires[1];
end;

Procedure DrawPoly(NumPoints: Word; var PolyPoints);
begin
  com.nr:=NumPoints;
  move(PolyPoints,com.pts,2*NumPoints*SizeOf(integer));
  callbgi(9,1+NumPoints*2);
end;

Procedure Ellipse(X, Y: Integer; StAngle, EndAngle: Word; XRadius, YRadius: Word);
begin
  com.i[0]:=x;com.i[1]:=y;
  com.w[2]:=stAngle;com.w[3]:=EndAngle;
  com.w[2]:=XRadius;com.w[3]:=YRadius;
  callbgi(10,6);
end;

Procedure FillEllipse(X, Y: Integer; XRadius, YRadius: Word);
begin
  com.i[0]:=x;com.i[1]:=y;
  com.w[2]:=XRadius;com.w[3]:=YRadius;
  callbgi(11,6);
end;

Procedure FillPoly(NumPoints: Word; var PolyPoints);
begin
  com.nr:=NumPoints;
  move(PolyPoints,com.pts,2*NumPoints*SizeOf(integer));
  callbgi(12,1+NumPoints*2);
end;

Procedure FloodFill(X, Y: Integer; Border: Word);
begin
  com.x1:=x;com.y1:=y;com.w3:=border;
  callbgi(12,3);
end;

Procedure GetArcCoords(var ArcCoords: ArcCoordsType);
begin
  askbgi(14,0,6);
  move(bgires,ArcCoords,sizeof(ArcCoords));
end;

Procedure GetAspectRatio(var Xasp, Yasp: Word);
begin
  askbgi(15,0,2);
  xasp:=bgires[0];yasp:=bgires[1];
end;

Function  GetBkColor: Word;
begin
  askbgi(16,0,1);
  GetBkColor:=bgires[0];
end;

Function  GetColor: Word;
begin
  askbgi(17,0,1);
  GetColor:=bgires[0];
end;

Procedure GetDefaultPalette(var Palette: PaletteType);
begin
  askbgi(18,0,SizeOf(Palette) div Sizeof(word));
  move(bgires,palette,sizeof(palette));
end;

Function  GetDriverName: string;
var
  s : string;
begin
  askbgi(19,0,Sizeof(s) div Sizeof(word));
  move(bgires,s,sizeof(s));
  GetDrivername:=s;
end;

Procedure GetFillPattern(var FillPattern: FillPatternType);
begin
  askbgi(20,0,Sizeof(FillPattern) div Sizeof(word));
  move(bgires,fillpattern,sizeof(fillpattern));
end;

Procedure GetFillSettings(var FillInfo: FillSettingsType);
begin
  askbgi(21,0,Sizeof(FillInfo) div Sizeof(word));
  move(bgires,fillinfo,sizeof(fillinfo));
end;

function  GetGraphMode: Integer;
begin
  askbgi(22,0,1);
  getgraphmode:=bgires[0];
end;

procedure GetImage(x1, y1, x2, y2: Integer; var BitMap);
begin
{23}
end;

Procedure GetLineSettings(var LineInfo: LineSettingsType);
begin
  askbgi(24,0,Sizeof(LineInfo) div Sizeof(word));
  move(bgires,lineinfo,sizeof(Lineinfo));
end;

Function  GetMaxColor: Word;
begin
  askbgi(25,0,1);
  getmaxcolor:=bgires[0];
end;

Function  GetMaxX: Word;
begin
  askbgi(26,0,1);
  getmaxx:=bgires[0];
end;

Function  GetMaxY: Word;
begin
  askbgi(27,0,1);
  getmaxy:=bgires[0];
end;

Function  GetModeName(ModeNumber: Integer): string;
var
  s : string;
begin
  com.i1:=ModeNumber;
  askbgi(28,1,Sizeof(s) div Sizeof(word));
  move(bgires,s,sizeof(s));
  GetModename:=s;
end;

Procedure GetPalette(var Palette: PaletteType);
begin
  askbgi(29,0,Sizeof(Palette) div Sizeof(word));
  move(bgires,palette,sizeof(Palette));
end;

Function  GetPaletteSize: Integer;
begin
  askbgi(30,0,1);
  GetPaletteSize:=bgires[0];
end;

Function  GetPixel(X,Y: Integer): Word;
begin
  com.x1:=x;com.y1:=y;
  askbgi(31,2,1);
  getpixel:=bgires[0];
end;

Procedure GetTextSettings(var TextInfo: TextSettingsType);
begin
  askbgi(32,0,Sizeof(textInfo) div Sizeof(word));
  move(bgires,textinfo,sizeof(textinfo));
end;

Procedure GetViewSettings(var ThisViewPort: ViewPortType);
begin
  askbgi(33,0,Sizeof(ThisViewPort) div Sizeof(word));
  move(bgires,ThisViewPort,sizeof(ThisViewPort));
end;

Function  GetX: Integer;
begin
  askbgi(34,0,1);
  getx:=bgires[0];
end;

Function  GetY: Integer;
begin
  askbgi(35,0,1);
  gety:=bgires[0];
end;

Procedure GraphDefaults;
begin
  flushdisplay;
  callbgi(36,0);
end;

Function  GraphErrorMsg(ErrorCode: Integer): String;
begin
  GraphErrorMsg:='';
end;

Function  GraphResult: Integer;
begin
  flushdisplay;
  graphresult:=0;
end;

function  ImageSize(x1, y1, x2, y2: Integer): Word;
begin
  com.i[0]:=x1;com.i[1]:=y1;com.i[2]:=x2;com.i[3]:=y2;
  askbgi(39,4,1);
  ImageSize:=bgires[0];
end;

procedure PushKey(Ch: Char);
begin
  if KeyCount < SizeOf(KeyBuffer) then
  begin
    KeyBuffer[KeyCount] := Ch;
    Inc(KeyCount);
  end;
end;

function Keypressed: Boolean;
begin
  KeyPressed := KeyCount > 0;
  If WaitKeypressed and ( KeyCount = 0 ) then
    DosSleep( 1 );
end;

function ReadKey: Char;
begin
  while not KeyPressed do
    ;
  ReadKey := KeyBuffer[0];
  Dec(KeyCount);
  Move(KeyBuffer[1], KeyBuffer[0], KeyCount);
end;

// Thread updating display at least 5x per second
function BGIUpdateThread( p: Pointer ): Longint;
begin
  while not Stopping do
    begin
      if DispPtr <> 0 then
        FlushDisplay;
      DosSleep( 200 );
    end;
end;

// Thread routing keyboard input from both TXT and BGI screen
function BGIKeyboardThread( p: Pointer ): Longint;
begin
  While not Stopping do
    begin
      // Ask if key was pressed in text mode screen
      If Crt.Keypressed then
        // Yes, add to buffer
        PushKey( Crt.Readkey )
      else
        if DispPtr = 0 then
          begin
            // Ask BGI if key is pressed, if no display items waiting
            askbgi(99,0,1);
            if bgires[0] <> 0 then
              PushKey( chr(bgires[0]) )
            else
              DosSleep( 31 );
          end
        else
          DosSleep( 31 );
    end;
end;

procedure InitGraph(var GraphDriver:Integer; var GraphMode: Integer;
                        PathToDriver: string);
var
  rc: ApiRet;
  SD: StartData;
  IdSession: ULong;
  Pid: ULong;
  s: String;
begin
  DispPtr:=0;

  // if AutoStartServer is false, the BGI server process must be started
  // manually by executing GRAPHSRV.EXE.
  if AutoStartServer then
    begin
      // Set up unique pipe name to allow multiple instances of
      // this program to run safely
      BGIPipeName := '\PIPE\BGI'+                           // Pipe prefix
                     Int2Hex( GetForegroundProcessID, 4 )+  // Process ID
                     Int2Hex( GetTimeMSec, 8 );             // Time in ms
      s := '/B'+PathToDriver+' /P'+BGIPipeName+#0;
      // Spawn Graph Server process
      fillchar( sd, sizeof(sd), 0 );
      with SD do
        begin
          Length      := sizeof(StartData);
          Related     := ssf_Related_Child;
          FgBg        := ssf_FgBg_Fore;
          TraceOpt    := ssf_TraceOpt_None;
          PgmTitle    := 'VP/2 BGI Graphics Server Process';
          PgmName     := 'graphsrv.exe';
          PgmInputs   := @s[1];

          TermQ       := nil;
          Environment := nil;
          InheritOpt  := ssf_InhertOpt_Parent;
          SessionType := ssf_Type_Pm;
          IconFile    := nil;
          PgmHandle   := 0;
          PgmControl  := ssf_Control_Visible;
        end;
      rc := DosStartSession( SD, IdSession, Pid );
      if ( rc <> No_Error ) and ( rc <> error_Smg_Start_In_Background ) then
        begin
          Writeln( 'Graph Server Process GRAPHSRV.EXE not found' );
          halt(1);
        end;
    end; // If AutoStartServer

{$I-}
  Close(f);
  Assign(f,BGIPipeName);
{$I+}
  if ioresult<>0 then;
  Stopping := False;
  // Create semaphores
  DosCreateMutexSem( nil, mtx_BGI, 0, False );
  // Start thread for trigging regular screen update
  tid_BGI := VPBeginThread( BGIUpdateThread, 16384, nil );
  // Start thread for watching the keyboard
  tid_Kbd := VPBeginThread( BGIKeyboardThread, 16384, nil );

  GraphDefaults;
  ClearDevice;

end;

Function  InstallUserFont(FontFileName: string) : Integer;
begin
  com.s:=fontfilename;
  askbgi(41,3,1);
  InstallUserFont:=bgires[0];
end;

Procedure Line(X1, Y1, X2, Y2: Integer);
begin
  com.i[0]:=x1;com.i[1]:=y1;
  com.i[2]:=x2;com.i[3]:=y2;
  callbgi(42,4);
end;

Procedure LineRel(Dx, Dy: Integer);
begin
  com.i[0]:=dx;com.i[1]:=dy;
  callbgi(43,2);
end;

Procedure LineTo(X, Y: Integer);
begin
  com.i[0]:=x;com.i[1]:=y;
  callbgi(44,2);
end;

Procedure MoveRel(Dx, Dy: Integer);
begin
  com.i[0]:=dx;com.i[1]:=dy;
  callbgi(45,2);
end;

Procedure MoveTo(X, Y: Integer);
begin
  com.i[0]:=x;com.i[1]:=y;
  callbgi(46,2);
end;

Procedure OutText(TextString: string);
begin
  com.i[0]:=0;com.i[1]:=0;
  com.s:=TextString;
  callbgi(47,3+(length(TextString) div sizeof(word)));
end;

Procedure OutTextXY(X, Y: Integer; TextString: string);
begin
  com.i[0]:=x;com.i[1]:=y;
  com.s:=TextString;
  callbgi(48,3+(length(TextString) div sizeof(word)));
end;

Procedure PieSlice(X, Y: Integer; StAngle, EndAngle, Radius: Word);
begin
  com.i[0]:=x;com.i[1]:=y;
  com.w[2]:=StAngle;com.w[3]:=EndAngle;com.w[4]:=Radius;
  callbgi(49,5);
end;

procedure PutImage(X, Y: Integer; var BitMap; BitBlt: Word);
begin
{50}
end;

Procedure PutPixel(X, Y: Integer; Color: Word);
begin
  com.i[0]:=x;com.i[1]:=y;com.w3:=Color;
  callbgi(51,3);
end;

Procedure Rectangle(X1, Y1, X2, Y2: Integer);
begin
  com.i[0]:=x1;com.i[1]:=y1;
  com.i[2]:=x2;com.i[3]:=y2;
  callbgi(52,4);
end;

Procedure RegisterBGIFont(FontID: Integer; Font: Pointer);
begin
  com.i1:=fontid;com.w2:=word(font);
  callbgi(53,2);
end;

Procedure Sector(X, Y: Integer; StAngle, EndAngle, XRadius, YRadius: Word);
begin
  com.i[0]:=x;com.i[1]:=y;
  com.w[2]:=StAngle;com.w[3]:=EndAngle;
  com.w[4]:=XRadius;com.w[5]:=YRadius;
  callbgi(54,6);
end;

Procedure SetAllPalette(var Palette: PaletteType);
begin
  move(palette,com.i[0],sizeof(Palette));
  callbgi(55,Sizeof(Palette) div Sizeof(word));
end;

Procedure SetAspectRatio(Xasp, Yasp: Word);
begin
  com.w1:=xasp;com.w2:=yasp;
  callbgi(56,2);
end;

Procedure SetBkColor(ColorNum: Word);
begin
  com.w[0]:=ColorNum;
  callbgi(57,1);
end;

Procedure SetColor(Color: Word);
begin
  com.w[0]:=Color;
  callbgi(58,1);
end;

Procedure SetFillPattern(Pattern: FillPatternType; Color: Word);
begin
  com.w1:=color;move(Pattern,com.w[1],sizeof(Pattern));
  callbgi(59,1+(sizeof(Pattern) div Sizeof(word)));
end;

Procedure SetFillStyle(Pattern: Word; Color: Word);
begin
  com.w[0]:=Pattern;
  com.w[1]:=Color;
  callbgi(60,2);
end;

Procedure SetLineStyle(LineStyle: Word; Pattern: Word; Thickness: Word);
begin
  com.w[0]:=LineStyle;
  com.w[1]:=Pattern;
  com.w[2]:=Thickness;
  callbgi(61,3);
end;

Procedure SetPalette(ColorNum: Word; Color: Byte);
begin
  com.w1:=colornum;
  com.w2:=color;
  callbgi(62,2);
end;

Procedure SetRGBPalette(ColorNum: Word; Red, Green, Blue: Byte);
begin
  com.w1:=colornum;
  com.w2:=red;com.w3:=green;com.w4:=blue;
  callbgi(63,4);
end;

Procedure SetTextJustify(Horiz, Vert: Word);
begin
  com.w[0]:=Horiz;
  com.w[1]:=Vert;
  callbgi(64,2);
end;

Procedure SetTextStyle(Font, Direction, CharSize: Integer);
begin
  com.i[0]:=Font;
  com.i[1]:=Direction;
  com.i[2]:=CharSize;
  callbgi(65,3);
end;

Procedure SetUserCharSize(MultX, DivX, MultY, DivY: Word);
begin
  com.w1:=multx;
  com.w2:=divx;
  com.w3:=multy;
  com.w4:=divy;
  callbgi(66,4);
end;

Procedure SetViewPort(X1, Y1, X2, Y2: Integer; Clip: Boolean);
begin
  com.x1:=x1;
  com.y1:=y1;
  com.x2:=x2;
  com.y2:=y2;
  if clip then com.w5:=1 else com.w5:=0;
  callbgi(67,5);
end;

Procedure SetWriteMode(WriteMode: Integer);
begin
  com.i[0]:=WriteMode;
  callbgi(68,1);
end;

Function  TextHeight(TextString: string): Word;
begin
  com.s:=TextString;
  askbgi(70,3+(length(TextString) div sizeof(word)),1);
  textHeight:=bgires[0];
end;

Function  TextWidth(TextString: string): Word;
begin
  com.s:=TextString;
  askbgi(70,3+(length(TextString) div sizeof(word)),1);
  textWidth:=bgires[0];
end;

// VP additional BGI functions
procedure SetWideFillPattern(Pattern: NewPatternType; Color: Word);
begin
  com.w1:=color;move(Pattern,com.w[1],sizeof(Pattern));
  callbgi(71,1+(sizeof(Pattern) div Sizeof(word)));
end;

end.
