{}
{                                                       }
{      Virtual Pascal v1.1                              }
{      BGI Graphics Server for mixed BGI/Textmode       }
{      }
{      Copyright (C) 1996 fPrint UK Ltd                 }
{        Written May-July 1996 by Allan Mertner         }
{        Pipe interface engineered by Alex Vermeulen    }
{                                                       }
{}

program GraphSrv;

{&PMTYPE PM}

uses Use32, Dos, Os2Def, Os2Base, Strings, Dgraph, BGImsg;

const
  Stopping : boolean = false;

procedure Error( No: Integer; s: String );
begin
  Case No of
    1 : ; // Cannot open BGI named pipe "s"
    2 : ; // Cannot create semaphore "s"
    3 : ; // Cannot link named pipe and semaphore.
    4 : ; // Cannot read data from pipe
    5 : ; // Cannot send result to client
    6 : ; // SetTextStyle failed; check BGIPath
  else
    // 'Unknown error occured';
  end;
  Halt( No );
end;

var
  r    : DisplayListT;
  hevn : HEv;
  pip  : HPipe;
  rc   : ApiRet;
  Ptr  : word;
  res  : BGIResArT;
  ulBytesR: uLong;
  ulBytes : uLong;

procedure openpipe( Name: String );
begin
  // Create named pipe for communicating with client
  name:=name+#0;
  rc:=DosCreateNPipe( @Name[1],pip,NP_ACCESS_DUPLEX,  // Duplex pipe
                      NP_WAIT OR
                      NP_WMESG OR                     // Write messages
                      NP_RMESG OR                     // Read messages
                      1,                              // Unique instance of pipe
                      256,                            // Output buffer size
                      4096*sizeof(Word),              // Input buffer size
                      1000);                          // Use default time-out
  if rc <> No_Error then
    Error( 1, Name );

  // Create event semaphore to link with pipe
  name := '\SEM32' + name;
  rc := DosCreateEventSem( @name[1], hevn, 0, false );
  if rc <> No_Error then
    Error( 2, Name );

  // Link semaphore and pipe together
  rc := DosSetNPipeSem( Pip, hsem(hevn), 1);
  if rc <> No_Error then
    Error( 3, '' );

  // Connect to the pipe
  DosConnectNPipe(Pip);
{   <> no_Error do
    DosSleep( 50 );}
end;

// WaitForConn: Wait for client to connect to the pipe
procedure WaitForConn;
var
  rc     : ApiRet;
  Buffer : Longint;
  fRead  : Longint;
  fAvail : AvailData;
  fState : Longint;

begin
  repeat
    // Wait 1/1000 sec for posting of the semaphore
    rc := DosWaitEventSem(hevn, 1 );
    // Have a look at the pipe data
    DosPeekNPipe(pip, Buffer, 0, fRead, fAvail, fState);
    if fAvail.cbPipe = 0 then
      begin
        // No data available in pipe
        if fState in [ np_state_Disconnected, np_State_Closing ] then
          begin
            // If exiting, return EOF
            Stopping := True;
            Exit;
          end;
        // No data: Wait a little before retrying
        DosSleep( 31 );
      end;
    // Stay in loop until data received
  until ( rc = No_Error ) and ( fAvail.cbPipe <> 0 );
end;

procedure ProcessBGIMessages;
var
  point  : ^CommandListT;
  nrpar  : word;
  len    : word;
  cmd    : word;
  lineS  : LineSettingsType;
  ArcC   : ArcCoordsType;
  Pal    : PaletteType;
  Fill   : FillPatternType;
  FillI  : FillSettingsType;
  textS  : TextSettingsType;
  View   : ViewPortType;

begin
  repeat
    repeat
      rc := DosRead(Pip,                  { Handle of pipe }
                    r,                    { Buffer for message read }
                    sizeof(DisplayListT), { Buffer size }
                    ulBytesR);            { Number of bytes actually read }
      if rc = Error_No_Data then
        DosSleep( 50 );
    until rc <> error_no_Data;

    if rc <> No_Error then
      // Error; cannot normally occur, since we know that there are
      // data in the pipe
      Error( 4, '' );

    // Stop DIVE from refreshing the display while drawing
    SuspendRefresh;
    Ptr    :=0;
    res[0] :=0;

    // Process all messages
    while Ptr < ulBytesR div Sizeof(word) do
    begin
      cmd   := r.w[Ptr];      // Command number
      nrpar := r.w[Ptr+1];    // Parameter count
      len   := r.w[Ptr+2];    // Length of expected return value
      point := @r.w[Ptr+3];   // Array of points (x,y)

      // Execute one command
      with point^ do
        case cmd of
          1: Arc(x1,y1,w3,w4,w5);
          2: Bar(x1,y1,x2,y2);
          3: Bar3D(x1,y1,x2,y2,w5,w6=1);
          4: Circle(x1,y1,w3);
          5: ClearDevice;
          6: ClearViewPort;
          7: CloseGraph;
          8: DetectGraph(res[0],res[1]);
          9: DrawPoly(nr,pts);
          10: Ellipse(x1,y1,w3,w4,w5,w6);
          11: FillEllipse(x1,y1,w3,w4);
          12: FillPoly(nr,pts);
          14: begin GetArcCoords(ArcC);move(arcC,res,sizeof(arcC)) end;
          15: GetAspectRatio(res[0],res[1]);
          16: res[0]:=getBkColor;
          17: res[0]:=GetColor;
          18: begin GetDefaultpalette(Pal);move(Pal,res,sizeof(Pal)) end;
          19: begin s:=GetDriverName;move(s,res,sizeof(s)) end;
          20: begin GetFillPattern(Fill);move(fill,res,sizeof(fill)) end;
          21: begin GetFillSettings(FillI);move(fillI,res,sizeof(fillI)) end;
          22: res[0]:=GetGraphMode;
          24: begin getlinesettings(lineS);move(lineS,res,sizeof(lineS)) end;
          25: res[0]:=GetMaxColor;
          26: res[0]:=GetMaxX;
          27: res[0]:=GetMaxY;
          28: begin s:=getModeName(w1);move(s,res,sizeof(s)) end;
          29: begin GetPalette(Pal); move(Pal,res,sizeof(Pal)) end;
          30: res[0]:=GetPaletteSize;
          31: res[0]:=GetPixel(x1,y1);
          32: begin gettextsettings(textS);move(texts,res,sizeof(texts)) end;
          33: begin getviewsettings(view);move(view,res,sizeof(view)) end;
          34: res[0]:=GetX;
          35: res[0]:=GetY;
          36: GraphDefaults;
          39: res[0]:=ImageSize(x1,y1,x2,y2);
          41: res[0]:=InstallUserFont(s);
          42: Line(x1,y1,x2,y2);
          43: LineRel(x1,y1);
          44: LineTo(x1,y1);
          45: MoveRel(x1,y1);
          46: MoveTo(x1,y1);
          47: OutText(s);
          48: OutTextXY(x1,y1,s);
          49: PieSlice(x1,y1,w3,w4,w5);
          51: PutPixel(x1,y1,w3);
          52: Rectangle(x1,y1,x2,y2);
          53: RegisterBGIFont(i1,pointer(w2));
          54: Sector(x1,y1,w3,w4,w5,w6);
          55: SetAllPalette(PaletteType(i[0]));
          56: SetAspectRatio(w1,w2);
          57: SetBkColor(w1);
          58: SetColor(w1);
          59: SetFillPattern(fillpatterntype(w[1]),w1);
          60: SetFillStyle(w1,w2);
          61: SetLineStyle(w1,w2,w3);
          62: SetPalette(w1,w2);
          63: SetRGBPalette(w1,w2,w3,w4);
          64: SetTextJustify(w1,w2);
          65: try
                SetTextStyle(i1,i2,i3);
              except
                Error( 6, '' );  // Could not find font
              end;
          66: SetUserCharSize(w1,w2,w3,w4);
          67: SetViewPort(x1,y1,x2,y2,w5=1);
          68: SetWriteMode(i1);
          69: res[0]:=TextHeight(s);
          70: res[0]:=TextWidth(s);
          71: SetWideFillPattern(newpatterntype(w[1]),w1);
          99: if keypressed then res[0] := ord(Readkey) else res[0] := 0;
        else
          // Ignore unknown commands
        end;

        // Skip command and parameters
        Inc(Ptr,nrpar+3);
      end;

    // Re-enable DIVE refreshind the display
    EnableRefresh;

    // Always send at least one word of acknowledgment to client
    if len = 0 then
      len := 1;

    if ulBytesR > 0 then
      begin
        rc:= DosWrite(Pip,              // Handle of pipe
                      res,              // Buffer containing message to write
                      len*sizeof(word), // Length of message
                      ulBytes);         // Number of bytes actually written

        if rc <> No_Error then
          Error( 5, '' );
      end;
  until ulBytesR = 0;
end;

// Close pipe connection
procedure shutconn;
begin
  rc := DosCloseEventSem(hevn);
  rc := DosDisConnectNPipe(Pip);
end;

var
  ok          : Integer;
  GraphMode   : Integer;
  GraphDriver : word;
  s           : String;
  x           : Integer;
  BGIPath     : String;

begin
  BGIPath := '';
  // Process command line parameters
  // -P<PipeName> sets the pipe name
  // -X<Number>   sets the horizontal resolution
  // -Y<Number>   sets the vertical resolution
  // -B<Path>     sets the path to BP BGI fonts
  for x:=1 to paramcount do
    begin
      s := ParamStr(x);
      if s[1] IN ['/','-'] then
        case upcase(s[2]) of
          'P': begin
                 BGIPipeName:=copy(s,3,length(s));
                 WindowTitle:=copy(s,3,length(s));
               end;
          'X': Val(copy(s,3,length(s)),X_Size,ok);
          'Y': Val(copy(s,3,length(s)),Y_Size,ok);
          'B': begin
                 BGIPath := s;
                 Delete( BGIPath, 1, 2 );
               end;
        end;
    end;

  // Initialise DIVE window
  GraphDriver:=Detect;
  if BGIPath = '' then
    BGIPath := GetEnv( 'BGIDIR' );
  InitGraph( GraphDriver, Graphmode, BGIPath );

  // Open pipe for communications with client
  OpenPipe(BGIPipeName);
  ClearDevice;
  GraphDefaults;

  // Receive and execute BGI commands
  repeat
    if not Stopping then
      ProcessBGIMessages;
  until Stopping;

  // Close the connection and the DIVE window
  ShutConn;
  CloseGraph;
end.



