#ifndef _DBSEARCHARG_H_
#define _DBSEARCHARG_H_

#include <objc/Object.h>

#define CMP_EQUAL        0x00
#define CMP_NOTEQUAL     0x01
#define CMP_LESS         0x02
#define CMP_GREATER      0x03
#define CMP_LESSEQUAL    0x04
#define CMP_GREATEREQUAL 0x05

@interface DBSearchArg : Object
{
  id    field;
  char  operator;
  char *operand;

  DBSearchArg *next;
}

- initForField: aField
      operator: (char) anOperator
   withOperand: (char *) anOperand;
- free;

- add: anArg;
- next;

-field;
-(char) operator;
-(char *) operand;

-(BOOL) matchesCurrentRecordInFile: aFile;

@end

#endif
