#ifndef _DBFILE_H_
#define _DBFILE_H_

#ifndef _DBTYPES_H_
#include "DBTypes.h"
#endif

#ifndef _DBFIELD_H_
#include "DBField.h"
#endif

#ifndef _DBSEARCHARG_H_
#include "DBSearchArg.h"
#endif

#ifndef _DBENTITIES_H_
#include "DBEntities.h"
#endif

#ifndef _SIMPLELIST_H_
#include <util/SimpleList.h>
#endif

#include <stdio.h>

@interface DBFile : Object <DBEntities>
{
   DBHEADER   *dbHeader;
   SimpleList *fieldList;

   FILE       *fileHandle;
   void       *buffer;
   char      **fieldOffset;
   long        currentRecord;

   char       *fileName;
   id          searchArguments;

   id          index;
}

- init:(char *) aFileName;
- create: (char *) aFileName withFields: (int) count list: (DBFIELD *) fields;
- free;

- field: (int) fieldNumber;
- (int) fieldCount;

- readRecord: (long) offset;
- writeRecord: (long) offset;
- (long) currentRecord;
- (BOOL) deleted;

- append;
- replace;
- delete;
- undelete;
- clear;

- (BOOL) findFirst;
- (BOOL) findNext;

- (void *) copyBuffer;
- (void *) copyBufferTo: (void *) aBuffer;
- setBuffer: (void *) aBuffer;

- (long) recordCount;

-setSearchArguments: args;
-searchArguments;

-useIndex: anIndex;

/* -------------------- Protocol "DBEntities" --------------------- */
-database;
-getProperties: (SimpleList *) aList;
-(BOOL) matchesEntity: (id <DBEntities>) anEntity;
-(const char *) entityName;
-propertyNamed: (const char *) aName;

@end

#endif
