/* -------------------------------------------------------------------

	Project: General utility classes

	Objective-C interface file for the class KeyedList

	COPYRIGHT (C), 1995, Thomas Baier
	ALL RIGHTS RESERVED.

	Date:				Rev: 0.1
	1995-Aug-01			___

 */

#ifndef _KEYEDLIST_H_
#define _KEYEDLIST_H_

/*====================================================================
                     Interface of class keyedlist                     
====================================================================*/
#include "SimpleList.h"

@interface KeyedList : SimpleList
{
  id *key;
}

/* -------------------------- Initialize -------------------------- */
-initCount: (unsigned long) aCount;

/* ----------------------------- Free ----------------------------- */
-free;
-freeObjects;

/* ----------- Methods for access to Instance Variables ----------- */

/* ------------------------ Public methods ------------------------ */
-addObject: anObject;
-addObject: anObject withKey: aKey;
-insertObject: anObject at: (unsigned long) position;
-insertObject: anObject withKey: aKey at: (unsigned long) position;
-lastKey;
-keyAt: (unsigned long) position;
-removeObjectAt: (unsigned long) position;
-replaceKeyAt: (unsigned long) position with: aKey;
-objectForKey: aKey;
-(unsigned long) indexForKey: aKey;

/* ----------------------- Private methods ------------------------ */

/* ---------------------- Archiving methods ----------------------- */
-read: (TypedStream *) aStream;
-write: (TypedStream *) aStream;

@end

#endif
