/* -------------------------------------------------------------------

	Project: 

	Objective-C interface file for the class IBOutlet

	COPYRIGHT (C), 1995, Thomas Baier
	ALL RIGHTS RESERVED.

	Date:				Rev:
	1995-Aug-28			___

 */

#ifndef _IBOUTLET_H_
#define _IBOUTLET_H_

/*====================================================================
                     Interface of class IBOutlet                      
====================================================================*/
#include <objc/Object.h>

@interface IBOutlet : Object
{
  id    source;
  id    target;
  char *variable;
}

/* -------------------------- Initialize -------------------------- */
-init;

/* ----------------------------- Free ----------------------------- */
-free;

/* ----------- Methods for access to Instance Variables ----------- */
-source;
-setSource: aSource;
-target;
-setTarget: aTarget;
-(char *) variable;
-setVariable: (char *) aVariable;

/* ------------------------ Public methods ------------------------ */

/* ----------------------- Private methods ------------------------ */

/* ---------------------- Archiving methods ----------------------- */
-read: (TypedStream *) aStream;
-write: (TypedStream *) aStream;

@end
#endif

