/* -------------------------------------------------------------------

	Project: General utility classes

	Objective-C interface file for the class SimpleList

	COPYRIGHT (C), 1995, Thomas Baier
	ALL RIGHTS RESERVED.

	Date:				Rev: 0.1
	1995-Jul-27			___

 */

#ifndef _SIMPLELIST_H_
#define _SIMPLELIST_H_

#ifndef INVALID_INDEX
#define INVALID_INDEX (unsigned long) -1
#endif

/*====================================================================
                    Interface of class SimpleList                     
====================================================================*/
#include <objc/Object.h>

@interface SimpleList : Object
{
  id *data;

  unsigned long count;
  unsigned long maxCount;

  unsigned long slots;
}

/* -------------------------- Initialize -------------------------- */
-init;
-initCount: (unsigned long) aCount;

/* ----------------------------- Free ----------------------------- */
-free;
-freeObjects;

/* ----------- Methods for access to Instance Variables ----------- */
-(unsigned long) count;

/* ------------------------ Public methods ------------------------ */
-addObject: anObject;
-appendList: (SimpleList *) otherList;
-empty;
-insertObject: anObject at: (unsigned long) position;
-lastObject;
-objectAt: (unsigned long) position;
-(unsigned long) indexOf: anObject;
-removeLastObject;
-removeObjectAt: (unsigned long) position;
-replaceObjectAt: (unsigned long) position with: anObject;

/* ----------------------- Private methods ------------------------ */

/* ---------------------- Archiving methods ----------------------- */
-read: (TypedStream *) aStream;
-write: (TypedStream *) aStream;

@end

#endif
