/* -------------------------------------------------------------------

	Project: 

	Objective-C source file for the class Controller

	This file was automatically generated by Project Editor
	COPYRIGHT (C), 1995, Thomas Baier

	Unregistered version

	COPYRIGHT (C), 1996
	ALL RIGHTS RESERVED.

	Date:                           Rev:
	Sat Jan 06 14:33:21 1996


------------------------------------------------------------------- */

/* ------------------------ Include files ------------------------- */
#include <io.h>
#include <sys/types.h>
#include <sys/stat.h>

/* ------------------------  Classes used  ------------------------ */


/* -------------------------  Externals  -------------------------- */


/* --------------------------  Defines  --------------------------- */


/* ----------------------  Class variables  ----------------------- */


/*====================================================================
                     Implementation of class Controller
====================================================================*/
#include "Controller.h"

@implementation Controller : Object
{
  id      mainWindow;
  id      mleWindow;
}

/*====================================================================
                              Initialize
====================================================================*/


/*====================================================================
                                 Free
====================================================================*/


/*====================================================================
               Methods for access to Instance Variables
====================================================================*/


/*====================================================================
                            Public methods
====================================================================*/

/*--------------------------------------------------------------------
|-loadFile: sender|

Return self.
--------------------------------------------------------------------*/
-loadFile: sender
{
  FileDlg *fileDlg = [[FileDlg alloc] initForOpen: "Open File..."
		      withFilter: "*.*"];
  if (([fileDlg runModalFor: mainWindow]) && ([fileDlg result] == DID_OK))
    [self readAndDisplayFile: [fileDlg fileName]];

  [fileDlg free];

  return self;
}


/*====================================================================
                           Private methods
====================================================================*/
/*--------------------------------------------------------------------
|-readAndDisplayFile: (char *) aFileName| 

Return self.
                                                          /1996-Jan-06
--------------------------------------------------------------------*/
-readAndDisplayFile: (char *) fileName
{
  char        *title;
  FILE        *inputFile;
  struct stat  statbuffer;
  char        *contents;

  if (stat (fileName,&statbuffer) < 0) { /* check file */

    [mleWindow setText: ""];
    [mainWindow setTitle: "Textview: no file loaded"];

    return nil;
  }

  /*
   * open file and read contents to buffer
   */
  inputFile = fopen (fileName,"r"); /* open text file read-only */
      
  contents = (char *) malloc (statbuffer.st_size + 1); /* allocate buffer */
  fread (contents,statbuffer.st_size,1,inputFile); /* read contents of file */
      
  /*
   * calculate title of window and set it
   */
  title = (char *) malloc (11 + /* this is the length of "Textview: " + 
				   NULL */
			   strlen (fileName)); /* allocate buffer 
						 for title */
  sprintf (title,"Textview: %s",fileName); /* fill title buffer */
  [mleWindow setText: contents]; /* display contents of file */
  [mainWindow setTitle: title];

  free (title);
  free (contents);

  fclose (inputFile); /* close file */
  
  return self;
}


/*====================================================================
                          Archiving methods
====================================================================*/
/*--------------------------------------------------------------------
|-awakeFromInterfaceFile| 

Return self.
                                                          /1996-Jan-06
--------------------------------------------------------------------*/
-awakeFromInterfaceFile
{
  [mainWindow bindCommand: 2001 withObject: self
                 selector: @selector (loadFile:)];
  [mainWindow bindCommand: 2002 withObject: mainWindow
                 selector: @selector (performClose:)];

  return self;
}

@end
