/*****************************************************************************/
/*	       Copyright (c) 1994 by Jyrki Salmi <jytasa@jyu.fi>             */
/*        You may modify, recompile and distribute this file freely.         */
/*****************************************************************************/

/*
   Routines that load TCP/IP's socket library and get the address of
   psock_errno() entry function that is used get information about the
   error occurred in the TCP/IP API.

   Reasons for not using an import library:

   (1) People without TCP/IP can still use the program. No attempt to use 
       the TCP/IP API is made if the device type is something else than
       socket.

   (2) Program can be recompiled without the TCP/IP programmers toolkit.
*/

#include <stdio.h>
#define INCL_DOSMODULEMGR
#include <os2.h>
#include "p.h"
#include "tcpipapi.h"
#include "error.h"
#include "modules.h"

static HMODULE dll_handle;
void (* _System psock_errno)(U8 *) = NULL;

void load_tcpip(void) {

  APIRET rc;

  rc = DosLoadModule(NULL, 0L, "SO32DLL", &dll_handle);
  if (rc)
    os2_error(P_ERROR_DOSLOADMODULE, rc,
	      MODULE_TCPIP, __LINE__,
	      "SO32DLL");

  /* Query the address of psock_errno() entry function */

  rc = DosQueryProcAddr(dll_handle,
			0,
			"PSOCK_ERRNO",
			(PFN *)&psock_errno);
  if (rc)
    os2_error(P_ERROR_DOSQUERYPROCADDR, rc,
	    MODULE_TCPIP, __LINE__,
	    "PSOCK_ERRNO");
}

void unload_tcpip(void) {

  APIRET rc;

  rc = DosFreeModule(dll_handle);
  if (rc)
    os2_error(P_ERROR_DOSFREEMODULE, rc,
	    MODULE_TCPIP, __LINE__,
	    "SO32DLL");
}
