/*****************************************************************************/
/*	       Copyright (c) 1994 by Jyrki Salmi <jytasa@jyu.fi>             */
/*        You may modify, recompile and distribute this file freely.         */
/*****************************************************************************/

/*
   A bit cleaner directory handling routines than the OS/2's DosFindFirst and
   DosFindNext. Note that dir_find_close() should be called when done with
   the directory listing.
*/

#include <stdio.h>
#define INCL_DOSFILEMGR
#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include "typedefs.h"
#include "dir.h"

/* Finds a first file */

U32 dir_find_first(U8 *mask,
		   U32 attribute,
		   DIR_ENTRY *dir_entry) {

  U32 find_count = 1;
  APIRET rc;

  if ((dir_entry->find_buf = malloc(sizeof(FILEFINDBUF3))) == NULL) {
    fprintf(stderr, "Failed to allocate memory\n");
    exit(1);
  }
  dir_entry->handle = HDIR_CREATE; /* HDIR_SYSTEM; */
  rc = DosFindFirst(mask,
		    &dir_entry->handle,
		    attribute,
		    dir_entry->find_buf,
		    sizeof(FILEFINDBUF3),
		    &find_count,
		    FIL_STANDARD);
  dir_entry->name = ((FILEFINDBUF3 *)dir_entry->find_buf)->achName;
  dir_entry->size = (U32 *)&((FILEFINDBUF3 *)dir_entry->find_buf)->cbFile;
  dir_entry->date = (U16 *)&((FILEFINDBUF3 *)dir_entry->find_buf)->fdateLastWrite;
  dir_entry->time = (U16 *)&((FILEFINDBUF3 *)dir_entry->find_buf)->ftimeLastWrite;
  dir_entry->attribute = &((FILEFINDBUF3 *)dir_entry->find_buf)->attrFile;
  return(rc);
}

/* Finds the next file */

U32 dir_find_next(DIR_ENTRY *dir_entry) {

  U32 find_count = 1;
  APIRET rc;

  rc = DosFindNext(dir_entry->handle,
		   dir_entry->find_buf,
		   sizeof(FILEFINDBUF3),
		   &find_count);
  dir_entry->name = ((FILEFINDBUF3 *)dir_entry->find_buf)->achName;
  dir_entry->size = (U32 *)&((FILEFINDBUF3 *)dir_entry->find_buf)->cbFile;
  dir_entry->date = (U16 *)&((FILEFINDBUF3 *)dir_entry->find_buf)->fdateLastWrite;
  dir_entry->time = (U16 *)&((FILEFINDBUF3 *)dir_entry->find_buf)->ftimeLastWrite;
  dir_entry->attribute = &((FILEFINDBUF3 *)dir_entry->find_buf)->attrFile;
  return(rc);
}

/* Ends the directory handling started by dir_find_first() */

U32 dir_find_close(DIR_ENTRY *dir_entry) {

  APIRET rc;

  rc = DosFindClose(dir_entry->handle);
  return(rc);
}
