#
# gprof/makefile
#
CC=gcc -O -g -DEMX -I../bfd -I../include -DMACHINE_H=\"i386.h\"

default: gprof.exe

gcrt0.o: gcrt0.s
	gcc -c -x assembler-with-cpp gcrt0.s

gmon.o: gmon.c gmon.h
	gcc -c -g gmon.c

profil.o: profil.c
	gcc -c -g -DDEBUG profil.c

GPROFOBJ = gprof.o basic_bl.o hist.o gmon_io.o cg_print.o call_gra.o \
	search_l.o cg_dfn.o cg_arcs.o i386.o hertz.o core.o symtab.o \
	sym_ids.o source.o utils.o flat_bl.o bsd_call.o fsf_call.o

GPROFLIB = ../bfd/libbfd.a ../libibert/libibert.a

gprof.exe: $(GPROFOBJ) $(GPROFLIB)
	$(CC) -Zsmall-conv -o gprof $(GPROFOBJ) $(GPROFLIB)
	emxbind -bqs gprof

gprof.o: gprof.c gprof.h gmon.h i386.h search_l.h call_gra.h
	$(CC) -c gprof.c

basic_bl.o: basic_bl.c basic_bl.h
	$(CC) -c basic_bl.c

hist.o: hist.c hist.h
	$(CC) -c hist.c

gmon_io.o: gmon_io.c gmon_io.h
	$(CC) -c gmon_io.c

cg_print.o: cg_print.c gprof.h
	$(CC) -c cg_print.c

call_gra.o: call_gra.c call_gra.h
	$(CC) -c call_gra.c

search_l.o: search_l.c search_l.h
	$(CC) -c search_l.c

cg_dfn.o: cg_dfn.c gprof.h
	$(CC) -c cg_dfn.c

cg_arcs.o: cg_arcs.c gprof.h
	$(CC) -c cg_arcs.c

i386.o: i386.c gprof.h
	$(CC) -c i386.c

hertz.o: hertz.c
	$(CC) -c hertz.c

core.o: core.c core.h
	$(CC) -c core.c

symtab.o: symtab.c symtab.h
	$(CC) -c symtab.c

sym_ids.o: sym_ids.c sym_ids.h
	$(CC) -c sym_ids.c

source.o: source.c source.h
	$(CC) -c source.c

utils.o: utils.c utils.h
	$(CC) -c utils.c

flat_bl.o: flat_bl.c
	$(CC) -c flat_bl.c

bsd_call.o: bsd_call.c
	$(CC) -c bsd_call.c

fsf_call.o: fsf_call.c
	$(CC) -c fsf_call.c

flat_bl.c: flat_bl.m
	awk -f gen-c-pr.awk FUNCTION=flat_blurb FILE=flat_bl.m \
		flat_bl.m >flat_bl.c

bsd_call.c: bsd_call.m
	awk -f gen-c-pr.awk FUNCTION=bsd_callg_blurb FILE=bsd_callg_bl.m \
		bsd_call.m >bsd_call.c

fsf_call.c: fsf_call.m
	awk -f gen-c-pr.awk FUNCTION=fsf_callg_blurb FILE=fsf_callg_bl.m \
		fsf_call.m >fsf_call.c
