#
# binutils/makefile
#
default: size objdump nm ar
exe: size.exe objdump.exe nm.exe ar.exe

CFLAGS=-O -g -I../bfd -I../include
LDFLAGS=-Zsmall-conv
CC=gcc $(CFLAGS)

LIBS=../bfd/libbfd.a ../libibert/libibert.a
BUOBJ=bucomm.o filemode.o version.o
DISASMOBJ=dis-buf.o disassem.o i386-dis.o

.c.o:
	$(CC) -c $<

size.exe: size
	emxbind -bqs size

objdump.exe: objdump
	emxbind -bqs objdump

nm.exe: nm
	emxbind -bqs nm

ar.exe: ar
	emxbind -bqs ar

size: size.o $(BUOBJ) $(LIBS)
	$(CC) $(LDFLAGS) -o size size.o $(BUOBJ) $(LIBS)

size.o: size.c bucomm.h

objdump: objdump.o $(BUOBJ) $(DISASMOBJ) $(LIBS)
	$(CC) $(LDFLAGS) -o objdump objdump.o $(BUOBJ) $(DISASMOBJ) $(LIBS)

objdump.o: objdump.c bucomm.h

nm: nm.o $(BUOBJ) $(LIBS)
	$(CC) $(LDFLAGS) -o nm nm.o $(BUOBJ) $(LIBS)

nm.o: nm.c bucomm.h

ar: ar.o arsup.o arparse.o arlex.o maybe-ra.o $(BUOBJ) $(LIBS)
	$(CC) $(LDFLAGS) -o ar ar.o arsup.o arparse.o arlex.o maybe-ra.o \
		$(BUOBJ) $(LIBS)

ar.o: ar.c arsup.h bucomm.h
arsup.o: arsup.c arsup.h bucomm.h
arparse.o: arparse.c arsup.h
arlex.o: arlex.c arparse.h
maybe-ra.o: maybe-ra.c

#arparse.c: arparse.y
#arlex.c: arlex.l

bucomm.o: bucomm.c bucomm.h

filemode.o: filemode.c

version.o: version.c
	$(CC) -c -DVERSION=\"2.6\" version.c

dis-buf.o: ../opcodes/dis-buf.c
	$(CC) -c ../opcodes/dis-buf.c

disassem.o: ../opcodes/disassem.c
	$(CC) -c -DARCH_i386 ../opcodes/disassem.c

i386-dis.o: ../opcodes/i386-dis.c
	$(CC) -c ../opcodes/i386-dis.c
