/* BFD back-end for emx a.out binaries, derived from i386aout.c and aout-target.h
   Copyright 1990, 1991, 1992 Free Software Foundation, Inc.

This file is part of BFD, the Binary File Descriptor library.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */


/* The only 386 aout system we have here is GO32 from DJ. 
   These numbers make BFD work with that. If your aout 386 system
   doesn't work with these, we'll have to split them into different
   files.  Send me (sac@cygnus.com) the runes to make it work on your
   system, and I'll stick it in for the next release.  */

#define N_HEADER_IN_TEXT(x) 0
#define BYTES_IN_WORD 4

#define TARGET_PAGE_SIZE       0x1000
#define SEGMENT_SIZE    0x10000
#define TEXT_START_ADDR 0x10000
#define DEFAULT_ARCH    bfd_arch_i386

#define MY(OP) CAT(emx_aout_,OP)
#define TARGETNAME "a.out-emx"
#define NO_WRITE_HEADER_KLUDGE 1

#define MY_object_p MY(object_p)

#include "bfd.h"

static PROTO (const bfd_target *, MY(callback), (bfd *abfd));
static PROTO (const bfd_target *, MY(object_p), (bfd *abfd));

#include "sysdep.h"
#include "libbfd.h"
#include "libaout.h"

#define MY_backend_data &MY(backend_data)
static boolean MY(set_sizes)();


static CONST struct aout_backend_data MY(backend_data) = {
  0,				/* zmagic contiguous */
  1,				/* text incl header */
  0,				/* exec_hdr_flags */
  0,				/* text vma? */
  MY(set_sizes),
  1,				/* exec header not counted */
  0,				/* add_dynamic_symbols */
  0,				/* add_one_symbol */
  0,				/* link_dynamic_object */
  0,				/* write_dynamic_symbol */
  0,				/* check_dynamic_reloc */
  0				/* finish_dynamic_link */
};

#include "aout-target.h"

/* Finish up the reading of an a.out file header */

static const bfd_target *
DEFUN(MY(object_p),(abfd),
     bfd *abfd)
{
  struct external_exec exec_bytes;	/* Raw exec header from file */
  struct internal_exec exec;		/* Cleaned-up exec header */
  const bfd_target *target;
  long org_pos, add;

  org_pos = bfd_tell (abfd);
  (void)_fseek_hdr(bfd_cache_lookup(abfd));
  add = bfd_tell (abfd) - org_pos;
  if (bfd_read ((PTR) &exec_bytes, 1, EXEC_BYTES_SIZE, abfd)
      != EXEC_BYTES_SIZE) {
    if (bfd_get_error () != bfd_error_system_call)
      bfd_set_error (bfd_error_wrong_format);
    return 0;
  }

  exec.a_info = bfd_h_get_32 (abfd, exec_bytes.e_info);

  if (N_BADMAG (exec)) return 0;

  NAME(aout,swap_exec_header_in)(abfd, &exec_bytes, &exec);
  exec.emx_add = add;
  target = NAME(aout,some_aout_object_p) (abfd, &exec, MY(callback));
  return target;
}
