/*----------------------------------------------------------------------*
 * Bounds Checking for GCC.						*
 * Copyright (C) 1995 Richard W.M. Jones <rwmj@doc.ic.ac.uk>.		*
 *----------------------------------------------------------------------*
 * This program is free software; you can redistribute it and/or modify	*
 * it under the terms of the GNU General Public License as published by	*
 * the Free Software Foundation; either version 2 of the License, or	*
 * (at your option) any later version.					*
 *									*
 * This program is distributed in the hope that it will be useful,	*
 * but WITHOUT ANY WARRANTY; without even the implied warranty of	*
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	*
 * GNU General Public License for more details.				*
 *									*
 * You should have received a copy of the GNU General Public License	*
 * along with this program; if not, write to the Free Software		*
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		*
 *----------------------------------------------------------------------*
 * File:
 *	lib/globals.c
 * Summary:
 *	I moved all the global variables here. All globals have to start
 *	with '__bounds' so they don't conflict with any other symbols in
 *	the program.
 * Other notes:
 *	
 * Author      	Date		Notes
 * RWMJ		15/3/95		Moved all globals to this file.
 *----------------------------------------------------------------------*/

#include "bounds-lib.h"

#include <signal.h>

/* This flag may be set by bounds-checking-aware programs to enable debugging
 * of all calls to this library. This flag is only available if DEBUG_FEATURES
 * is set in `bounds-lib.h'.
 */
int __bounds_debug_print_calls = 0;

/* This flag may be set to disable checking for a section of the program. This
 * flag is only available if DEBUG_FEATURES is set in `bounds-lib.h'.
 */
int __bounds_debug_no_checking = 0;

/* Warn if references are made to an unchecked static object.
 */
int __bounds_warn_unchecked_statics = 0;

/* Warn if references are made to an unchecked stack object.
 */
int __bounds_warn_unchecked_stack = 0;

#if COLLECT_STATS
/* Collect statistics on calling frequencies. The statistics are taken in
 * 'check.c'.
 */
int __bounds_stats_ptr_plus_int = 0;
int __bounds_stats_array_reference = 0;
int __bounds_stats_component_reference = 0;
int __bounds_stats_ptr_diff = 0;
int __bounds_stats_reference = 0;
int __bounds_stats_ptr_le_ptr = 0;
int __bounds_stats_ptr_lt_ptr = 0;
int __bounds_stats_ptr_ge_ptr = 0;
int __bounds_stats_ptr_gt_ptr = 0;
int __bounds_stats_ptr_ne_ptr = 0;
int __bounds_stats_ptr_eq_ptr = 0;
int __bounds_stats_ptr_postinc = 0;
int __bounds_stats_ptr_preinc = 0;
int __bounds_stats_ptr_postdec = 0;
int __bounds_stats_ptr_predec = 0;
int __bounds_stats_ptr_true = 0;
int __bounds_stats_ptr_false = 0;
int __bounds_stats_push_function = 0;
int __bounds_stats_pop_function = 0;
int __bounds_stats_param_function = 0;
int __bounds_stats_environment = 0;
int __bounds_stats_add_stack = 0;
int __bounds_stats_delete_stack = 0;
int __bounds_stats_add_heap = 0;
int __bounds_stats_delete_heap = 0;
int __bounds_stats_unchecked_static = 0;
int __bounds_stats_unchecked_stack = 0;

#endif /* COLLECT_STATS */

/* check the array indexes by default. This does not work for structures
 * like:
 *	struct ... {
 *		...other data ...
 *		char text[1]; -- string: structure expands to actual len .
 *	};
 * where you overwrite the end of the structure by the actual name. For these
 * kind of programs you have to set the __bounds_array_index_check to 0.
 * The better way is to modify the program and use a structure like:
 *	struct ... {
 *		...other data ...
 *		char *text;
 *	};
 * The disadvantage is that you have to call malloc twice to get the
 * structure.
 * The advantage is that you can check all array indexes in the program.
 */

int  __bounds_array_index_check = 0;

/* Don't free up VM addresses on the heap. We can track stale heap pointers
 * this way, the disadvantage being that we may run out of VM addresses. It
 * is best to ensure that 'munmap' is being called in 'malloc.c', so that
 * physical memory is recycled when this option is being used.
 */
/* Free up VM addresses on the heap after an age limit has expired. We can
 * track most stale heap pointers this way if 'age_limit' is set large
 * enough. However, if you really want to check all stale pointer, then
 * set 'never_free_heap' to 1 and stale pointers over the whole lifetime
 * of the program will be found.
 */
int  __bounds_never_free_heap = 0;
int  __bounds_age_limit = 0;

/* Warn if 'free (0)' is called. This is apparently valid in ANSI C.
 */
int  __bounds_warn_free_null = 0;

/* Give warnings for miscellaneous strangenesses in the strings library, eg.
 * NULL pointer passed to memcpy but with zero size. X11 likes to do
 * this sort of thing.
 */
int  __bounds_warn_misc_strings = 0;

/* Warn when ILLEGAL pointers are generated, so you can track them down more
 * easily. These patches were provided by Don Lewis <gdonl@gv.ssi1.com>.
 */
int  __bounds_warn_illegal = 0;

/* Warn if a pointer is used unaligned, for instance, if the user attempts to
 * read an array of integers as chars. Being able to switch this off was
 * suggested by Stuart Kemp and Eberhard Mattes (see CONTRIBUTORS).
 */
int  __bounds_warn_unaligned = 1;

/* By popular demand, a flag that causes the library to continue after hitting
 * a bounds error. The second and subsequent errors may be unpredictable
 * results of the first error.
 */
int  __bounds_never_fatal = 0;

/* If we are using Sys V-style signal handling, and we want mutual exclusion
 * when we enter and leave critical library functions, this variable is used
 * to store the current signal mask state.
 */
sigset_t __bounds_old_mask;
