/* math3n.vs -- `float' test vector for testing nextafter(). */

/* NaN */

{0x7fc00001,        /* NaN */
 0x7fc00002,        /* NaN */
 0x7fc00001,        /* x (or y) */
 0},

{0x7fc00002,        /* NaN */
 0x7fc00001,        /* NaN */
 0x7fc00002,        /* x (or y) */
 0},

{0x40000000,        /* +normal */
 0x7fc00001,        /* NaN */
 0x7fc00001,        /* y */
 0},

{0x7fc00001,        /* NaN */
 0x40000000,        /* +normal */
 0x7fc00001,        /* x */
 0},

{0x7f800000,        /* +inf */
 0xffc00000,        /* NaN */
 0xffc00000,        /* y */
 0},

{0xffc00000,        /* NaN */
 0x7f800000,        /* +inf */
 0xffc00000,        /* x */
 0},

/* x == y */

{0x00000000,        /* +0.0 */
 0x00000000,        /* +0.0 */
 0x00000000,        /* +0.0 */
 0},

{0x80000000,        /* -0.0 */
 0x80000000,        /* -0.0 */
 0x80000000,        /* -0.0 */
 0},

{0x00000000,        /* +0.0 */
 0x80000000,        /* -0.0 */
 0x80000000,        /* -0.0 */
 0},

{0x80000000,        /* -0.0 */
 0x00000000,        /* +0.0 */
 0x00000000,        /* +0.0 */
 0},

{0x00123456,        /* +denormal */
 0x00123456,        /* +denormal */
 0x00123456,        /* +denormal */
 0},                /* no exceptions! */

{0x80123456,        /* -denormal */
 0x80123456,        /* -denormal */
 0x80123456,        /* -denormal */
 0},                /* no exceptions! */

{0x12345678,        /* +normal */
 0x12345678,        /* +normal */
 0x12345678,        /* +normal */
 0},

{0x92345678,        /* -normal */
 0x92345678,        /* -normal */
 0x92345678,        /* -normal */
 0},

{0x7f800000,        /* +inf */
 0x7f800000,        /* +inf */
 0x7f800000,        /* +inf */
 0},                /* no exceptions! */

{0xff800000,        /* -inf */
 0xff800000,        /* -inf */
 0xff800000,        /* -inf */
 0},                /* no exceptions! */

/* Cases where the magnitude grows. */

{0x00000000,        /* +0.0 */
 0x7f800000,        /* +inf */
 0x00000001,        /* +smallest denormal */
 SW_UNDERFLOW | SW_INEXACT},

{0x80000000,        /* -0.0 */
 0xff800000,        /* -inf */
 0x80000001,        /* -smallest denormal */
 SW_UNDERFLOW | SW_INEXACT},

{0x00000000,        /* +0.0 */
 0xff800000,        /* -inf */
 0x80000001,        /* -smallest denormal */
 SW_UNDERFLOW | SW_INEXACT},

{0x80000000,        /* -0.0 */
 0x7f800000,        /* +inf */
 0x00000001,        /* +smallest denormal */
 SW_UNDERFLOW | SW_INEXACT},

{0x00000001,        /* +smallest denormal */
 0x3f800000,        /* +1.0 */
 0x00000002,        /* +next denormal */
 SW_UNDERFLOW | SW_INEXACT},

{0x80000001,        /* -smallest denormal */
 0xbf800000,        /* -1.0 */
 0x80000002,        /* -next denormal */
 SW_UNDERFLOW | SW_INEXACT},

{0x007fffff,        /* +biggest denormal */
 0x3f800000,        /* +1.0 */
 0x00800000,        /* +smallest normal */
 0},

{0x807fffff,        /* -biggest denormal */
 0xbf800000,        /* -1.0 */
 0x80800000,        /* -smallest normal */
 0},

{0x12345678,        /* +normal */
 0x7f800000,        /* +inf */
 0x12345679,        /* +next normal */
 0},

{0x92345678,        /* -normal */
 0xff800000,        /* -inf */
 0x92345679,        /* -next normal */
 0},

{0x337fffff,        /* Test incrementing exponent */
 0x7f800000,        /* +inf */
 0x33800000,
 0},

{0xb37fffff,        /* Test incrementing exponent */
 0xff800000,        /* -inf */
 0xb3800000,
 0},

{0x4ccccccc,        /* +normal */
 0x00000000,        /* +0.0 */
 0x4ccccccb,
 0},

{0xcccccccc,        /* -normal */
 0x80000000,        /* -0.0 */
 0xcccccccb,
 0},

{0x4ccccccc,        /* +normal */
 0x80000000,        /* -0.0 */
 0x4ccccccb,
 0},

{0xcccccccc,        /* -normal */
 0x00000000,        /* +0.0 */
 0xcccccccb,
 0},

{0x12345678,        /* +normal */
 0x123456ff,        /* +normal (|y| > |x| */
 0x12345679,        /* +next normal */
 0},

{0x92345678,        /* -normal */
 0x923456ff,        /* -normal (|y| > |x| */
 0x92345679,        /* -next normal */
 0},

{0x7f7fffff,        /* +biggest normal */
 0x7f800000,        /* +inf */
 0x7f800000,        /* +inf */
 SW_OVERFLOW | SW_INEXACT},

{0xff7fffff,        /* -biggest normal */
 0xff800000,        /* -inf */
 0xff800000,        /* -inf */
 SW_OVERFLOW | SW_INEXACT},

/* Cases where the magnitude shrinks. */

{0x7f800000,        /* +inf */
 0xff800000,        /* -inf */
 0x7f7fffff,        /* +biggest normal */
 0},

{0xff800000,        /* -inf */
 0x7f800000,        /* +inf */
 0xff7fffff,        /* -biggest normal */
 0},

{0x7654321a,        /* +normal */
 0x00000000,        /* +0.0 */
 0x76543219,        /* +smaller normal */
 0},

{0xf654321a,        /* -normal */
 0x80000000,        /* -0.0 */
 0xf6543219,        /* -smaller normal */
 0},

{0x33800000,        /* Test decrementing exponent */
 0xff800000,        /* -inf */
 0x337fffff,
 0},

{0xb3800000,        /* Test decrementing exponent */
 0x7f800000,        /* +inf */
 0xb37fffff,
 0},

{0x66666666,        /* Test y=+0.0 */
 0x00000000,        /* +0.0 */
 0x66666665,
 0},

{0x66666666,        /* Test y=-0.0 */
 0x80000000,        /* +0.0 */
 0x66666665,
 0},

{0x12345678,        /* +normal */
 0x12345600,        /* +normal (|y| < |x| */
 0x12345677,        /* +smaller normal */
 0},

{0x92345678,        /* -normal */
 0x92345600,        /* -normal (|y| < |x| */
 0x92345677,        /* -smaller normal */
 0},

{0x12345678,        /* +normal */
 0x923456ff,        /* -normal (|y| > |x| */
 0x12345677,        /* +smaller normal */
 0},

{0x92345678,        /* -normal */
 0x123456ff,        /* +normal (|y| > |x| */
 0x92345677,        /* -smaller normal */
 0},

{0x12345678,        /* +normal */
 0x92345600,        /* -normal (|y| < |x| */
 0x12345677,        /* +smaller normal */
 0},

{0x92345678,        /* -normal */
 0x12345600,        /* +normal (|y| < |x| */
 0x92345677,        /* -smaller normal */
 0},

{0x00800000,        /* +smallest normal */
 0xbf800000,        /* -1.0 */
 0x007fffff,        /* +biggest denormal */
 SW_UNDERFLOW | SW_INEXACT},

{0x80800000,        /* -smallest normal */
 0x3f800000,        /* +1.0 */
 0x807fffff,        /* -biggest denormal */
 SW_UNDERFLOW | SW_INEXACT},

{0x00123456,        /* +denormal */
 0x00000000,        /* +0.0 */
 0x00123455,        /* +smaller denormal */
 SW_UNDERFLOW | SW_INEXACT},

{0x80123456,        /* -denormal */
 0x80000000,        /* -0.0 */
 0x80123455,        /* -smaller denormal */
 SW_UNDERFLOW | SW_INEXACT},

{0x00000001,        /* +smallest denormal */
 0x00000000,        /* +0.0 */
 0x00000000,        /* +0.0 */
 0},

{0x80000001,        /* -smallest denormal */
 0x80000000,        /* -0.0 */
 0x80000000,        /* -0.0 */
 0},

{0x00000001,        /* +smallest denormal */
 0x80000000,        /* -0.0 */
 0x00000000,        /* +0.0 */
 0},

{0x80000001,        /* -smallest denormal */
 0x00000000,        /* +0.0 */
 0x80000000,        /* -0.0 */
 0}
