/* regexx1.cmd -- Test regexx.dll */

call RxFuncAdd 'RegexxLoadFuncs', 'regexx', 'RegexxLoadFuncs'
call RegexxLoadFuncs

say RegexxStart('x', 'abc')
say RegexxStart('b', 'abc')
say RegexxStart('a.b', 'abca!bc')
say RegexxStart('a(bc)+d', 'adabdacdabcbcde')
say RegexxStart('\(\\\)', 'abc(\)def')
say RegexxStart('\.', 'a.b')

signal on syntax name error
say RegexxStart('(a', 'a')
say 'Error expected, but there was no error...'
error:
signal off syntax

say RegexxEnd('456', '1234567')
say RegexxEnd('456', 'abcdefh')

say RegexxSubstr('x+', 'abxxxc')
say RegexxSubstr('y+', 'abxxxc')

say RegexxReplaceMatch('a(.)+b', 'x\1y', '12a345b67')
say RegexxReplaceMatch('a(.+)b', 'x\1y', '12a345b67')
say RegexxReplaceMatch('a(.)+b', 'x\1y', '')

say RegexxReplaceFirst('a', 'b', 'c')
say RegexxReplaceFirst('a', 'A', 'blablab')
say RegexxReplaceFirst('a([0-9]*)b', 'x\1y', '**a17b**')

say RegexxReplaceAll('a', 'b', 'c')
say RegexxReplaceAll('a', 'A', 'blablab')
say RegexxReplaceAll('a([0-9]*)b', 'x\1y', '**a17b!!ab##')
