/* xchg.c */

/* Regression test for __cxchg(), __lxchg(), and __sxchg(). */

#include <assert.h>
#include <stdlib.h>
#include <sys/builtin.h>

int main (void)
{
  signed char c1, c2;
  short s1, s2;
  int i1, i2;

  c1 = 5;
  c2 = __cxchg (&c1, 19);
  assert (c1 == 19); assert (c2 == 5);

  s1 = -3;
  s2 = __sxchg (&s1, 3141);
  assert (s1 == 3141); assert (s2 == -3);
  
  i1 = 1;
  i2 = __lxchg (&i1, 271828);
  assert (i1 == 271828); assert (i2 == 1);

  return 0;
}
