/* coreheap.c (emx+gcc) */

/* Test multiple heap objects in core dump.

   Build with "emxbind -b -h1 coreheap". */

#include <stdio.h>
#include <stdlib.h>


static void usage (void)
{
  puts ("Usage: coreheap <number>");
  exit (1);
}


int main (int argc, char *argv[])
{
  void *p;
  char *end;
  int i;
  long n;

  if (argc != 2)
    usage ();
  n = strtol (argv[1], &end, 10);
  if (n < 1 || n > 100 || *end != 0)
    usage ();

  for (i = 0; i < (int)n; ++i)
    {
      p = malloc (700*1024);
      if (p == NULL)
        {
          puts ("Out of memory.");
          return 2;
        }
      sprintf ((char *)p, "malloc() call #%d\n", i + 1);
    }
  puts ("Memory allocated, now terminating abnormally to dump core.");
  abort ();
  return 0;
}
