/* sig1.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

volatile int ack;

void handler (int sig)
{
  putchar ('s');
  if (ack)
    signal (sig, SIG_ACK);
}


int main (int argc, char *argv[])
{
  int signo;

  setvbuf (stdout, NULL, _IONBF, 0);
  if (argc == 1)
    signo = 1;
  else if (argc == 2)
    signo = atoi (argv[1]);
  else
    {
      puts ("Usage: sig1 [<signal number>]\n");
      return 1;
    }
  if (signal (signo, handler) == SIG_ERR)
    {
      fputs ("signal failed\n", stderr);
      return 1;
    }
  printf ("Expected output: +s-+s--+s+s+s-x\n");
  printf ("Actual output:   ");
  ack = 0;
  putchar ('+');
  raise (signo);
  putchar ('-');
  raise (signo);
  putchar ('+');
  signal (signo, SIG_ACK);
  putchar ('-');
  raise (signo);
  putchar ('-');
  raise (signo);
  ack = 1;
  putchar ('+');
  signal (signo, SIG_ACK);
  putchar ('+');
  raise (signo);
  putchar ('+');
  raise (signo);
  signal (signo, SIG_IGN);
  putchar ('-');
  raise (signo);
  signal (signo, SIG_DFL);
  putchar ('x');
  /* signal (signo, SIG_ACK); */
  putchar ('\n');
  raise (signo);
  if (signo != SIGCHLD && signo != SIGUSR1 && signo != SIGUSR2)
    printf ("You should not see this text.\n");
  return 0;
}
