/* read_kbd.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>

#define NORETURN2 __attribute__ ((noreturn))

static void usage (void) NORETURN2;

static void usage (void)
{
  fputs ("Usage: read_kbd <echo> <wait> <sig>\n", stderr);
  exit (1);
}


static int bool_arg (const char *arg)
{
  if (strcmp (arg, "0") == 0)
    return 0;
  else if (strcmp (arg, "1") == 0)
    return 1;
  else
    usage ();
}


int main (int argc, char *argv[])
{
  int echo, wait, sig;
  int c;

  if (argc != 4)
    usage ();
  echo = bool_arg (argv[1]);
  wait = bool_arg (argv[2]);
  sig = bool_arg (argv[3]);
  do
    {
      c = _read_kbd (echo, wait, sig);
      if (c < 0)
        printf (".");
      else
        printf (" %.2x ", c);
    } while (c != 0x1b);
  return 0;
}
