/* sys/waitpid.c (emx+gcc) -- Copyright (c) 1993-1996 by Eberhard Mattes */

#define INCL_DOSPROCESS
#include <os2emx.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __waitpid (int pid, int *status, int options)
{
  ULONG rc;
  RESULTCODES res;
  PID pid2;

  if (pid == -1)
    pid = 0;
  rc = DosWaitChild (DCWA_PROCESS, DCWW_WAIT, &res, &pid2, pid);
  if (rc != 0)
    {
      _sys_set_errno (rc);
      return -1;
    }
  *status = res.codeResult << 8;
  return pid2;
}
