/* sys/sigsuspe.c (emx+gcc) -- Copyright (c) 1994-1996 by Eberhard Mattes */

#define INCL_DOSEXCEPTIONS
#include <os2emx.h>
#include <errno.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __sigsuspend (const sigset_t *mask)
{
  sigset_t old_blocked;
  thread_data *tp;

  /* TODO: Critical section */
  tp = SYS_THREAD;
  old_blocked = tp->sig_blocked;
  SET_BLOCKED (tp, *mask);
  __pause ();
  tp->sig_blocked = old_blocked;
  errno = EINTR;
  return -1;
}
