/* locales.c (emx+gcc) -- Copyright (c) 1994-1996 by Eberhard Mattes */

#include <stdlib.h>
#include <limits.h>
#include <locale.h>
#include <emx/locale.h>

/* ---------------------------------- C ---------------------------------- */

static const struct lc_collate c_collate = {0};
static const struct lc_ctype c_ctype = {0};
static const struct lc_monetary c_monetary =
{
  "", "", "", "", "", "", "",
  CHAR_MAX, CHAR_MAX, CHAR_MAX, CHAR_MAX,
  CHAR_MAX, CHAR_MAX, CHAR_MAX, CHAR_MAX
};
static const struct lc_numeric c_numeric = {".", "", ""};
static const struct lc_time c_time =
{
  "Jan\0Feb\0Mar\0Apr\0May\0Jun\0Jul\0Aug\0Sep\0Oct\0Nov\0Dec",
  "January\0February\0March\0April\0May\0June\0"
    "July\0August\0September\0October\0November\0December",
  "Sun\0Mon\0Tue\0Wed\0Thu\0Fri\0Sat",
  "Sunday\0Monday\0Tuesday\0Wednesday\0Thursday\0Friday\0Saturday",
  "%a %b %d %H:%M:%S %Y", "%m/%d/%y", "%H:%M:%S",
  "AM", "PM"
};

/* --------------------------------- FRAN -------------------------------- */

#define fran_collate c_collate
#define fran_ctype   c_ctype
static const struct lc_monetary fran_monetary =
{
  "FRF ", "F", ",", ".", "\3", "", "-",
  2, 2, 0, 1, 0, 1, 1, 1
};
static const struct lc_numeric fran_numeric = {",", " ", "\3"};
static const struct lc_time fran_time =
{
  "jan\0fev\0mar\0avr\0mai\0jun\0jui\0aou\0sep\0oct\0nov\0dec",
  "janvier\0f\\'evrier\0mars\0avril\0mai\0juin\0"
    "juillet\0ao\\^ut\0septembre\0octobre\0novembre\0d\\'ecembre",
  "Dim\0Lun\0Mar\0Mer\0Jeu\0Ven\0Sam",
  "Dimanche\0Lundi\0Mardi\0Mercredi\0Jeudi\0Vendredi\0Samedi",
  "%d-%m-%y %H.%M.%S", "%d.%m.%y", "%H.%M.%S",
  "", ""
};

/* --------------------------------- GERM -------------------------------- */

#define germ_collate c_collate
#define germ_ctype   c_ctype
static const struct lc_monetary germ_monetary =
{
  "DEM ", "DM", ",", ".", "\3", "", "-",
  2, 2, 1, 0, 1, 0, 1, 1
};
static const struct lc_numeric germ_numeric = {",", ".", "\3"};
static const struct lc_time germ_time =
{
  "Jan\0Feb\0Mrz\0Apr\0Mai\0Jun\0Jul\0Aug\0Sep\0Okt\0Nov\0Dez",
  "Januar\0Februar\0M\\\"arz\0April\0Mai\0Juni\0"
    "Juli\0August\0September\0Oktober\0November\0Dezember",
  "So\0Mo\0Di\0Mi\0Do\0Fr\0Sa",
  "Sonntag\0Montag\0Dienstag\0Mittwoch\0Donnerstag\0Freitag\0Samstag",
  "%A, %d. %B %Y %H.%M.%S", "%d.%m.%Y", "%H.%M.%S",
  "", ""
};

/* --------------------------------- ITAL -------------------------------- */

#define ital_collate c_collate
#define ital_ctype   c_ctype
static const struct lc_monetary ital_monetary =
{
  "ITL. ", "L.", "", ".", "\3", "", "-",
  0, 0, 1, 1, 1, 1, 1, 1
};
#define ital_numeric germ_numeric
static const struct lc_time ital_time =
{
  "GEN\0FEB\0MAR\0APR\0MAG\0GIU\0LUG\0AGO\0SET\0OTT\0NOV\0DIC",
  "gennaio\0febbraio\0marzo\0aprile\0maggio\0giugno\0"
    "luglio\0agosto\0settembre\0ottobre\0novembre\0dicembre",
  "DOM\0LUN\0MAR\0MER\0GIO\0VEN\0SAB",
  "dom\\'enica\0luned\\`i\0marted\\`i\0mercoled\\`i\0"
    "gioved\\`i\0venerd\\`i\0s\\`abato",
  "%d/%m/%Y %H:%M:%S", "%d/%m/%y", "%H:%M:%S",
  "", ""
};

/* --------------------------------- NETH -------------------------------- */

#if 0

#define neth_collate c_collate
#define neth_ctype   c_ctype
static const struct lc_monetary neth_monetary =
{
  "NLG ", "F", ",", ".", "\3", "", "-",
  2, 2, 1, 1, 1, 1, 1, 4
};
#define neth_numeric germ_numeric
#define neth_time    c_time

#endif

/* --------------------------------- NORW -------------------------------- */

#if 0

#define norw_collate c_collate
#define norw_ctype   c_ctype
static const struct lc_monetary norw_monetary =
{
  "NOK ", "kr", ",", ".", "\3", "", "-",
  2, 2, 1, 0, 1, 0, 1, 2
};
#define norw_numeric germ_numeric
#define norw_time    c_time

#endif

/* --------------------------------- SPAI -------------------------------- */

#define spai_collate c_collate
#define spai_ctype   c_ctype
static const struct lc_monetary spai_monetary =
{
  "ESP ", "Pts", "", ".", "\3", "", "-",
  0, 0, 1, 1, 1, 1, 1, 1
};
#define spai_numeric germ_numeric
static const struct lc_time spai_time =
{
  "ENE\0FEB\0MAR\0ABR\0MAY\0JUN\0JUL\0AGO\0SEP\0OCT\0NOV\0DIC",
  "Enero\0Febrero\0Marzo\0Abril\0Mayo\0Junio\0"
    "Julio\0Agosto\0Septiembre\0Octubre\0Noviembre\0Diciembre",
  "DOM\0LUN\0MAR\0MIE\0JUE\0VIE\0SAB",
  "Domingo\0Lunes\0Martes\0Miercoles\0Jueves\0Viernes\0Sabado",
  "%d %B %Y %H:%M:%S", "%d/%m/%y", "%H:%M:%S",
  "", ""
};

/* --------------------------------- UK ---------------------------------- */

#define uk_collate c_collate
#define uk_ctype   c_ctype
static const struct lc_monetary uk_monetary =
{
  "GBP ", "$", ".", ",", "\3", "", "-",
  2, 2, 1, 0, 1, 0, 1, 1
};
#define uk_numeric usa_numeric
static const struct lc_time uk_time =
{
  "Jan\0Feb\0Mar\0Apr\0May\0Jun\0Jul\0Aug\0Sep\0Oct\0Nov\0Dec",
  "January\0February\0March\0April\0May\0June\0"
    "July\0August\0September\0October\0November\0December",
  "Sun\0Mon\0Tue\0Wed\0Thu\0Fri\0Sat",
  "Sunday\0Monday\0Tuesday\0Wednesday\0Thursday\0Friday\0Saturday",
  "%d/%m/%y %H:%M:%S", "%d/%m/%y", "%H:%M:%S",
  "", ""
};

/* --------------------------------- USA --------------------------------- */

#define usa_collate c_collate
#define usa_ctype   c_ctype
static const struct lc_monetary usa_monetary =
{
  "AMD ", "$", ".", ",", "\3", "", "-",
  2, 2, 1, 0, 1, 0, 1, 1
};
static const struct lc_numeric usa_numeric = {".", ",", "\3"};
#define usa_time    c_time

/* -------------------------------- en_us -------------------------------- */

#define en_us_collate c_collate
#define en_us_ctype   c_ctype
static const struct lc_monetary en_us_monetary =
{
  "USD ", "$", ".", ",", "\3", "", "-",
  2, 2, 1, 0, 1, 0, 2, 2
};
#define en_us_numeric usa_numeric
#define en_us_time    c_time

/* -------------------------------- en_gb -------------------------------- */

#define en_gb_collate c_collate
#define en_gb_ctype   c_ctype
static const struct lc_monetary en_gb_monetary =
{
  "GBP ", "", ".", ",", "\3", "+", "-",
  2, 2, 1, 0, 1, 0, 1, 1
};
#define en_gb_numeric usa_numeric
#define en_gb_time    c_time

/* ----------------------------------------------------------------------- */

/* The type casts are used for removing constness. */

#define DATA(NAME,PFX) \
  { \
     NAME, \
     (struct lc_collate *)&PFX##_collate, \
     (struct lc_ctype *)&PFX##_ctype, \
     (struct lc_monetary *)&PFX##_monetary, \
     (struct lc_numeric *)&PFX##_numeric, \
     (struct lc_time *)&PFX##_time \
   }

const struct lc_data _lc_table[] =
{
  DATA ("C", c),
  DATA ("FRAN", fran),
  DATA ("GERM", germ),
  DATA ("ITAL", ital),
#if 0
  DATA ("NETH", neth),
  DATA ("NORW", norw),
#endif
  DATA ("SPAI", spai),
  DATA ("UK", uk),
  DATA ("USA", usa),
  DATA ("de_de", germ),
  DATA ("en_us", en_us),
  DATA ("en_gb", en_gb),
  {NULL, NULL, NULL, NULL, NULL, NULL}
};
