/* wmvprint.c (emx+gcc) -- Copyright (c) 1987-1996 by Eberhard Mattes */

#include <stdio.h>
#include <stdarg.h>
#include <sys/winmgr.h>
#include <emx/io.h>
#include "winmgr2.h"

static int _wm_flush (FILE *stream, int c)
{
  int n;
  wm_handle wh;

  wh = (wm_handle)stream->_tmpidx;
  n = stream->_ptr - stream->_buffer;
  if (n > 0)
    _wm_puts_len (wh, stream->_buffer, n);
  stream->_ptr = stream->_buffer;
  *stream->_ptr++ = (char)c;
  stream->_wcount = stream->_buf_size - 1;
  return 0;
}


int wm_vprintf (wm_handle wh, const char *fmt, va_list arg_ptr)
{
  FILE trick;
  struct _file2 trick2;
  int result;
  char buf[512];

  trick._buffer = buf;
  trick._ptr = buf;
  trick._rcount = 0;
  trick._wcount = sizeof (buf);
  trick._handle = -1;
  trick._flags = _IOOPEN|_IOSPECIAL|_IOBUFUSER|_IOWRT;
  trick._buf_size = sizeof (buf);
  trick._flush = _wm_flush;
  trick._tmpidx = (int)wh;
  trick._ungetc_count = 0;
  _setdummymore (&trick, &trick2);
  result = _output (&trick, fmt, arg_ptr);
  _wm_flush (&trick, 0);
  _wm_cursor1 ();
  return result;
}
